/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.WritableTypeId;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;

public class LocalDateSerializer
extends JSR310FormattedSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();

    protected LocalDateSerializer() {
        super(LocalDate.class);
    }

    protected LocalDateSerializer(LocalDateSerializer localDateSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(localDateSerializer, bl2, dateTimeFormatter, shape);
    }

    public LocalDateSerializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDate.class, dateTimeFormatter);
    }

    protected LocalDateSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new LocalDateSerializer(this, bl2, dateTimeFormatter, shape);
    }

    @Override
    public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                jsonGenerator.writeNumber(localDate.toEpochDay());
            } else {
                jsonGenerator.writeStartArray();
                this._serializeAsArrayContents(localDate, jsonGenerator, serializerProvider);
                jsonGenerator.writeEndArray();
            }
        } else {
            jsonGenerator.writeString(this._formatter == null ? localDate.toString() : localDate.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        JsonToken jsonToken;
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(localDate, this.serializationShape(serializerProvider)));
        JsonToken jsonToken2 = jsonToken = writableTypeId == null ? null : writableTypeId.valueShape;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(localDate, jsonGenerator, serializerProvider);
        } else if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            jsonGenerator.writeNumber(localDate.toEpochDay());
        } else {
            jsonGenerator.writeString(this._formatter == null ? localDate.toString() : localDate.format(this._formatter));
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void _serializeAsArrayContents(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(localDate.getYear());
        jsonGenerator.writeNumber(localDate.getMonthValue());
        jsonGenerator.writeNumber(localDate.getDayOfMonth());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        boolean bl2;
        SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
        boolean bl3 = bl2 = serializerProvider != null && this.useTimestamp(serializerProvider);
        if (bl2) {
            this._acceptTimestampVisitor(jsonFormatVisitorWrapper, javaType);
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (jsonStringFormatVisitor != null) {
                jsonStringFormatVisitor.format(JsonValueFormat.DATE);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        if (this.useTimestamp(serializerProvider)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.START_ARRAY;
        }
        return JsonToken.VALUE_STRING;
    }
}

