/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.key;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.key.Jsr310KeyDeserializer;

public class MonthDayKeyDeserializer
extends Jsr310KeyDeserializer {
    public static final MonthDayKeyDeserializer INSTANCE = new MonthDayKeyDeserializer();
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

    private MonthDayKeyDeserializer() {
    }

    @Override
    protected MonthDay deserialize(String string, DeserializationContext deserializationContext) throws IOException {
        try {
            return MonthDay.parse(string, PARSER);
        }
        catch (DateTimeException dateTimeException) {
            return (MonthDay)this._handleDateTimeException(deserializationContext, MonthDay.class, dateTimeException, string);
        }
    }
}

