/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.StreamReadCapability;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.NumberInput;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;

public class YearDeserializer
extends JSR310DateTimeDeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearDeserializer INSTANCE = new YearDeserializer();

    public YearDeserializer() {
        this((DateTimeFormatter)null);
    }

    public YearDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(Year.class, dateTimeFormatter);
    }

    protected YearDeserializer(YearDeserializer yearDeserializer, Boolean bl2) {
        super(yearDeserializer, bl2);
    }

    public YearDeserializer(YearDeserializer yearDeserializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(yearDeserializer, bl2, dateTimeFormatter, shape);
    }

    protected YearDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new YearDeserializer(this, (Boolean)this._isLenient, dateTimeFormatter, this._shape);
    }

    @Override
    protected YearDeserializer withLeniency(Boolean bl2) {
        return new YearDeserializer(this, bl2);
    }

    @Override
    public Year deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonToken == JsonToken.START_OBJECT) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this._fromNumber(deserializationContext, jsonParser.getIntValue());
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (Year)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return (Year)this._deserializeFromArray(jsonParser, deserializationContext);
        }
        return (Year)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
    }

    protected Year _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (Year)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(string2)) {
            return this._fromNumber(deserializationContext, NumberInput.parseInt(string2));
        }
        try {
            if (this._formatter == null) {
                return Year.parse(string2);
            }
            return Year.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (Year)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }

    protected Year _fromNumber(DeserializationContext deserializationContext, int n2) {
        return Year.of(n2);
    }
}

