/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.Month;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.exc.InvalidFormatException;

public class OneBasedMonthDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Pattern HAS_ONE_OR_TWO_DIGITS = Pattern.compile("^\\d{1,2}$");

    public OneBasedMonthDeserializer(JsonDeserializer<?> jsonDeserializer) {
        super(jsonDeserializer);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        Month month = (Month)this.getDelegatee().deserialize(jsonParser, deserializationContext);
        if (!this._isNumericValue(jsonParser.getText(), jsonToken)) {
            return month;
        }
        if (month == Month.JANUARY) {
            throw new InvalidFormatException(jsonParser, "Month.JANUARY value not allowed for 1-based Month.", (Object)month, Month.class);
        }
        return month.minus(1L);
    }

    private boolean _isNumericValue(String string, JsonToken jsonToken) {
        return jsonToken == JsonToken.VALUE_NUMBER_INT || this._isNumberAsString(string, jsonToken);
    }

    private boolean _isNumberAsString(String string, JsonToken jsonToken) {
        return jsonToken == JsonToken.VALUE_STRING && HAS_ONE_OR_TWO_DIGITS.matcher(string).matches();
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
        return new OneBasedMonthDeserializer(jsonDeserializer);
    }
}

