/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonEncoding;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerationException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParseException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.ObjectCodec;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Version;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.format.InputAccessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.format.MatchStrength;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.IOContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.VersionUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlFactoryBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlNameProcessors;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.io.Stax2CharArraySource;

public class XmlFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_XML = "XML";
    static final int DEFAULT_XML_PARSER_FEATURE_FLAGS = FromXmlParser.Feature.collectDefaults();
    static final int DEFAULT_XML_GENERATOR_FEATURE_FLAGS = ToXmlGenerator.Feature.collectDefaults();
    protected int _xmlParserFeatures;
    protected int _xmlGeneratorFeatures;
    protected transient XMLInputFactory _xmlInputFactory;
    protected transient XMLOutputFactory _xmlOutputFactory;
    protected String _cfgNameForTextElement;
    protected XmlNameProcessor _nameProcessor;
    protected transient String _jdkXmlInFactory;
    protected transient String _jdkXmlOutFactory;
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    private static final byte BYTE_x = 120;
    private static final byte BYTE_m = 109;
    private static final byte BYTE_l = 108;
    private static final byte BYTE_D = 68;
    private static final byte BYTE_LT = 60;
    private static final byte BYTE_QMARK = 63;
    private static final byte BYTE_EXCL = 33;
    private static final byte BYTE_HYPHEN = 45;

    public XmlFactory() {
        this(null, null, null);
    }

    public XmlFactory(ObjectCodec objectCodec) {
        this(objectCodec, null, null);
    }

    public XmlFactory(XMLInputFactory xMLInputFactory) {
        this(null, xMLInputFactory, null);
    }

    public XmlFactory(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(null, xMLInputFactory, xMLOutputFactory);
    }

    public XmlFactory(ObjectCodec objectCodec, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(objectCodec, DEFAULT_XML_PARSER_FEATURE_FLAGS, DEFAULT_XML_GENERATOR_FEATURE_FLAGS, xMLInputFactory, xMLOutputFactory, null);
    }

    public XmlFactory(ObjectCodec objectCodec, int n2, int n3, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory, String string) {
        this(objectCodec, n2, n3, xMLInputFactory, xMLOutputFactory, string, XmlNameProcessors.newPassthroughProcessor());
    }

    protected XmlFactory(ObjectCodec objectCodec, int n2, int n3, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory, String string, XmlNameProcessor xmlNameProcessor) {
        super(objectCodec);
        this._nameProcessor = xmlNameProcessor;
        this._xmlParserFeatures = n2;
        this._xmlGeneratorFeatures = n3;
        this._cfgNameForTextElement = string;
        if (xMLInputFactory == null) {
            xMLInputFactory = StaxUtil.defaultInputFactory(this.getClass().getClassLoader());
            xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xMLInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        }
        if (xMLOutputFactory == null) {
            xMLOutputFactory = StaxUtil.defaultOutputFactory(this.getClass().getClassLoader());
            xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        this._initFactories(xMLInputFactory, xMLOutputFactory);
        this._xmlInputFactory = xMLInputFactory;
        this._xmlOutputFactory = xMLOutputFactory;
    }

    protected XmlFactory(XmlFactory xmlFactory, ObjectCodec objectCodec) {
        super(xmlFactory, objectCodec);
        this._xmlParserFeatures = xmlFactory._xmlParserFeatures;
        this._xmlGeneratorFeatures = xmlFactory._xmlGeneratorFeatures;
        this._cfgNameForTextElement = xmlFactory._cfgNameForTextElement;
        this._xmlInputFactory = xmlFactory._xmlInputFactory;
        this._xmlOutputFactory = xmlFactory._xmlOutputFactory;
        this._nameProcessor = xmlFactory._nameProcessor;
    }

    protected XmlFactory(XmlFactoryBuilder xmlFactoryBuilder) {
        super(xmlFactoryBuilder, false);
        this._xmlParserFeatures = xmlFactoryBuilder.formatParserFeaturesMask();
        this._xmlGeneratorFeatures = xmlFactoryBuilder.formatGeneratorFeaturesMask();
        this._cfgNameForTextElement = xmlFactoryBuilder.nameForTextElement();
        this._xmlInputFactory = xmlFactoryBuilder.xmlInputFactory();
        this._xmlOutputFactory = xmlFactoryBuilder.xmlOutputFactory();
        this._nameProcessor = xmlFactoryBuilder.xmlNameProcessor();
        this._initFactories(this._xmlInputFactory, this._xmlOutputFactory);
    }

    public static XmlFactoryBuilder builder() {
        return new XmlFactoryBuilder();
    }

    public XmlFactoryBuilder rebuild() {
        return new XmlFactoryBuilder(this);
    }

    protected void _initFactories(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }

    @Override
    public XmlFactory copy() {
        this._checkInvalidCopy(XmlFactory.class);
        return new XmlFactory(this, null);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    protected Object readResolve() {
        XMLOutputFactory xMLOutputFactory;
        XMLInputFactory xMLInputFactory;
        if (this._jdkXmlInFactory == null) {
            throw new IllegalStateException("No XMLInputFactory class name read during JDK deserialization");
        }
        if (this._jdkXmlOutFactory == null) {
            throw new IllegalStateException("No XMLOutputFactory class name read during JDK deserialization");
        }
        try {
            xMLInputFactory = (XMLInputFactory)Class.forName(this._jdkXmlInFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            xMLOutputFactory = (XMLOutputFactory)Class.forName(this._jdkXmlOutFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return new XmlFactory(this._objectCodec, this._xmlParserFeatures, this._xmlGeneratorFeatures, xMLInputFactory, xMLOutputFactory, this._cfgNameForTextElement);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._jdkXmlInFactory = objectInputStream.readUTF();
        this._jdkXmlOutFactory = objectInputStream.readUTF();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._xmlInputFactory.getClass().getName());
        objectOutputStream.writeUTF(this._xmlOutputFactory.getClass().getName());
    }

    public void setXMLTextElementName(String string) {
        this._cfgNameForTextElement = string;
    }

    public String getXMLTextElementName() {
        return this._cfgNameForTextElement;
    }

    public final XmlFactory configure(FromXmlParser.Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public XmlFactory enable(FromXmlParser.Feature feature) {
        this._xmlParserFeatures |= feature.getMask();
        return this;
    }

    public XmlFactory disable(FromXmlParser.Feature feature) {
        this._xmlParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(FromXmlParser.Feature feature) {
        return (this._xmlParserFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFormatParserFeatures() {
        return this._xmlParserFeatures;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return this._xmlGeneratorFeatures;
    }

    public XmlNameProcessor getXmlNameProcessor() {
        return this._nameProcessor;
    }

    public void setXmlNameProcessor(XmlNameProcessor xmlNameProcessor) {
        this._nameProcessor = xmlNameProcessor;
    }

    public final XmlFactory configure(ToXmlGenerator.Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public XmlFactory enable(ToXmlGenerator.Feature feature) {
        this._xmlGeneratorFeatures |= feature.getMask();
        return this;
    }

    public XmlFactory disable(ToXmlGenerator.Feature feature) {
        this._xmlGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(ToXmlGenerator.Feature feature) {
        return (this._xmlGeneratorFeatures & feature.getMask()) != 0;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this._xmlInputFactory;
    }

    @Deprecated
    public void setXMLInputFactory(XMLInputFactory xMLInputFactory) {
        this._xmlInputFactory = xMLInputFactory;
    }

    public XMLOutputFactory getXMLOutputFactory() {
        return this._xmlOutputFactory;
    }

    @Deprecated
    public void setXMLOutputFactory(XMLOutputFactory xMLOutputFactory) {
        this._xmlOutputFactory = xMLOutputFactory;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_XML;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        return XmlFactory.hasXMLFormat(inputAccessor);
    }

    @Override
    public boolean requiresCustomCodec() {
        return true;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    public Class<FromXmlParser.Feature> getFormatReadFeatureType() {
        return FromXmlParser.Feature.class;
    }

    public Class<ToXmlGenerator.Feature> getFormatWriteFeatureType() {
        return ToXmlGenerator.Feature.class;
    }

    @Override
    public JsonParser createParser(String string) throws IOException {
        Reader reader = new StringReader(string);
        IOContext iOContext = this._createContext(this._createContentReference(reader), true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createParser(reader, iOContext);
    }

    @Override
    public ToXmlGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    @Override
    public ToXmlGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(iOContext, outputStream), this._nameProcessor);
    }

    @Override
    public ToXmlGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(writer), false);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(iOContext, writer), this._nameProcessor);
    }

    @Override
    public ToXmlGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(this._createContentReference(fileOutputStream), true);
        iOContext.setEncoding(jsonEncoding);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(iOContext, fileOutputStream), this._nameProcessor);
    }

    public FromXmlParser createParser(XMLStreamReader xMLStreamReader) throws IOException {
        if (xMLStreamReader.getEventType() != 1) {
            xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        }
        FromXmlParser fromXmlParser = new FromXmlParser(this._createContext(this._createContentReference(xMLStreamReader), false), this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    public ToXmlGenerator createGenerator(XMLStreamWriter xMLStreamWriter) throws IOException {
        xMLStreamWriter = this._initializeXmlWriter(xMLStreamWriter);
        IOContext iOContext = this._createContext(this._createContentReference(xMLStreamWriter), false);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, xMLStreamWriter, this._nameProcessor);
    }

    @Override
    protected FromXmlParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected FromXmlParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected FromXmlParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory instanceof XMLInputFactory2 ? this._xmlInputFactory.createXMLStreamReader((Source)new Stax2CharArraySource(cArray, n2, n3)) : this._xmlInputFactory.createXMLStreamReader(new CharArrayReader(cArray, n2, n3));
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected FromXmlParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) throws IOException {
        XMLStreamReader xMLStreamReader;
        block6: {
            try {
                if (this._xmlInputFactory instanceof XMLInputFactory2) {
                    xMLStreamReader = this._xmlInputFactory.createXMLStreamReader((Source)new Stax2ByteArraySource(byArray, n2, n3));
                    break block6;
                }
                try {
                    xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(byArray, n2, n3));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new JsonParseException(null, "Internal processing error by `XMLInputFactory` of type " + ClassUtil.classNameOf(this._xmlInputFactory) + " when trying to create a parser (consider using Woodstox instead): " + arrayIndexOutOfBoundsException.getMessage());
                }
            }
            catch (XMLStreamException xMLStreamException) {
                return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
            }
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        VersionUtil.throwInternal();
        return null;
    }

    protected XMLStreamWriter _createXmlWriter(IOContext iOContext, OutputStream outputStream) throws IOException {
        XMLStreamWriter xMLStreamWriter;
        try {
            xMLStreamWriter = this._xmlOutputFactory.createXMLStreamWriter(this._decorate(iOContext, outputStream), "UTF-8");
        }
        catch (Exception exception) {
            throw new JsonGenerationException(exception.getMessage(), exception, null);
        }
        return this._initializeXmlWriter(xMLStreamWriter);
    }

    protected XMLStreamWriter _createXmlWriter(IOContext iOContext, Writer writer) throws IOException {
        XMLStreamWriter xMLStreamWriter;
        try {
            xMLStreamWriter = this._xmlOutputFactory.createXMLStreamWriter(this._decorate(iOContext, writer));
        }
        catch (Exception exception) {
            throw new JsonGenerationException(exception.getMessage(), exception, null);
        }
        return this._initializeXmlWriter(xMLStreamWriter);
    }

    protected final XMLStreamWriter _initializeXmlWriter(XMLStreamWriter xMLStreamWriter) throws IOException {
        try {
            xMLStreamWriter.setDefaultNamespace("");
        }
        catch (Exception exception) {
            throw new JsonGenerationException(exception.getMessage(), exception, null);
        }
        return xMLStreamWriter;
    }

    protected final XMLStreamReader _initializeXmlReader(XMLStreamReader xMLStreamReader) throws IOException {
        try {
            while (xMLStreamReader.next() != 1) {
            }
        }
        catch (Exception exception) {
            throw new JsonParseException(null, exception.getMessage(), (Throwable)exception);
        }
        return xMLStreamReader;
    }

    public static MatchStrength hasXMLFormat(InputAccessor inputAccessor) throws IOException {
        boolean bl2;
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by2 = inputAccessor.nextByte();
        if (by2 == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by2 = inputAccessor.nextByte();
        }
        boolean bl3 = bl2 = by2 == 60;
        if (!bl2) {
            int n2 = XmlFactory.skipSpace(inputAccessor, by2);
            if (n2 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            by2 = (byte)n2;
            if (by2 != 60) {
                return MatchStrength.NO_MATCH;
            }
        }
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        by2 = inputAccessor.nextByte();
        if (by2 == 63) {
            by2 = inputAccessor.nextByte();
            if (by2 == 120) {
                if (bl2 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 109 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 108) {
                    return MatchStrength.FULL_MATCH;
                }
                return MatchStrength.SOLID_MATCH;
            }
            if (XmlFactory.validXmlNameStartChar(inputAccessor, by2)) {
                return MatchStrength.SOLID_MATCH;
            }
        } else if (by2 == 33) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by2 = inputAccessor.nextByte();
            if (by2 == 45) {
                if (!inputAccessor.hasMoreBytes()) {
                    return MatchStrength.INCONCLUSIVE;
                }
                if (inputAccessor.nextByte() == 45) {
                    return MatchStrength.SOLID_MATCH;
                }
            } else if (by2 == 68) {
                return XmlFactory.tryMatch(inputAccessor, "OCTYPE", MatchStrength.SOLID_MATCH);
            }
        } else if (XmlFactory.validXmlNameStartChar(inputAccessor, by2)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static final boolean validXmlNameStartChar(InputAccessor inputAccessor, byte by2) throws IOException {
        int n2 = by2 & 0xFF;
        return n2 >= 65;
    }

    private static final MatchStrength tryMatch(InputAccessor inputAccessor, String string, MatchStrength matchStrength) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() == string.charAt(i2)) continue;
            return MatchStrength.NO_MATCH;
        }
        return matchStrength;
    }

    private static final int skipSpace(InputAccessor inputAccessor, byte by2) throws IOException {
        int n2;
        while ((n2 = by2 & 0xFF) == 32 || n2 == 13 || n2 == 10 || n2 == 9) {
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by2 = inputAccessor.nextByte();
            n2 = by2 & 0xFF;
        }
        return n2;
    }

    protected OutputStream _decorate(IOContext iOContext, OutputStream outputStream) throws IOException {
        OutputStream outputStream2;
        if (this._outputDecorator != null && (outputStream2 = this._outputDecorator.decorate(iOContext, outputStream)) != null) {
            return outputStream2;
        }
        return outputStream;
    }

    protected Writer _decorate(IOContext iOContext, Writer writer) throws IOException {
        Writer writer2;
        if (this._outputDecorator != null && (writer2 = this._outputDecorator.decorate(iOContext, writer)) != null) {
            return writer2;
        }
        return writer;
    }
}

