/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.SerializableString;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.AnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.EnumNamingStrategy;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.EnumFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public final class EnumValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;
    private transient EnumMap<?, SerializableString> _asMap;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this._enumClass = clazz;
        this._values = clazz.getEnumConstants();
        this._textual = serializableStringArray;
    }

    public static EnumValues construct(SerializationConfig serializationConfig, AnnotatedClass annotatedClass) {
        if (serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(serializationConfig, annotatedClass);
        }
        return EnumValues.constructFromName(serializationConfig, annotatedClass);
    }

    @Deprecated
    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        String[] stringArray = mapperConfig.getAnnotationIntrospector().findEnumValues(clazz2, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            if (mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE)) {
                string = string.toLowerCase();
            }
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumValues._enumClass(clazz);
        Enum<?>[] enumArray = EnumValues._enumConstants(clazz);
        String[] stringArray = annotationIntrospector.findEnumValues(mapperConfig, annotatedClass, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            if (bl2) {
                string = string.toLowerCase();
            }
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz2, serializableStringArray);
    }

    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumValues._enumClass(clazz);
        Enum<?>[] enumArray = EnumValues._enumConstants(clazz);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, annotatedClass, enumArray, stringArray);
        }
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            Enum<?> enum_;
            String string = stringArray[i2];
            if (string == null && (string = (enum_ = enumArray[i2]).toString()) == null) {
                string = "";
            }
            if (bl2) {
                string = string.toLowerCase();
            }
            serializableStringArray[i2] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz2, serializableStringArray);
    }

    @Deprecated
    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enum_.toString());
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumValues._enumClass(clazz);
        Enum<?>[] enumArray = EnumValues._enumConstants(clazz);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, annotatedClass, enumArray, stringArray);
        }
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            }
            if (bl2) {
                string = string.toLowerCase();
            }
            serializableStringArray[i2] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz2, serializableStringArray);
    }

    @Deprecated
    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, EnumNamingStrategy enumNamingStrategy) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enumNamingStrategy.convertEnumToExternalName(enum_.name()));
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues construct(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, List<String> list) {
        int n2 = list.size();
        SerializableString[] serializableStringArray = new SerializableString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            serializableStringArray[i2] = mapperConfig.compileString(list.get(i2));
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        return new EnumValues(clazz, serializableStringArray);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    public SerializableString serializedValueFor(Enum<?> enum_) {
        return this._textual[enum_.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public EnumMap<?, SerializableString> internalMap() {
        EnumMap<Object, SerializableString> enumMap = this._asMap;
        if (enumMap == null) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Enum<?> enum_ : this._values) {
                linkedHashMap.put(enum_, this._textual[enum_.ordinal()]);
            }
            this._asMap = enumMap = new EnumMap(linkedHashMap);
        }
        return enumMap;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

