/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyName;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CacheProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.Annotated;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.SerializerCache;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.SerializerFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class DefaultSerializerProvider
extends SerializerProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Map<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;
    protected transient JsonGenerator _generator;

    protected DefaultSerializerProvider() {
    }

    protected DefaultSerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(serializerProvider, serializationConfig, serializerFactory);
    }

    protected DefaultSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        super(defaultSerializerProvider);
    }

    protected DefaultSerializerProvider(DefaultSerializerProvider defaultSerializerProvider, CacheProvider cacheProvider) {
        super(defaultSerializerProvider, new SerializerCache(cacheProvider.forSerializerCache(defaultSerializerProvider._config)));
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public DefaultSerializerProvider copy() {
        throw new IllegalStateException("DefaultSerializerProvider sub-class not overriding copy()");
    }

    @Override
    public JsonSerializer<Object> serializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonSerializer jsonSerializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonSerializer) {
            jsonSerializer = (JsonSerializer)object;
        } else {
            HandlerInstantiator handlerInstantiator;
            Class clazz;
            if (!(object instanceof Class)) {
                this.reportBadDefinition(annotated.getType(), "AnnotationIntrospector returned serializer definition of type " + object.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            if ((clazz = (Class)object) == JsonSerializer.None.class || ClassUtil.isBogusClass(clazz)) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom(clazz)) {
                this.reportBadDefinition(annotated.getType(), "AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonSerializer>");
            }
            JsonSerializer jsonSerializer2 = jsonSerializer = (handlerInstantiator = this._config.getHandlerInstantiator()) == null ? null : handlerInstantiator.serializerInstance(this._config, annotated, clazz);
            if (jsonSerializer == null) {
                jsonSerializer = (JsonSerializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        return this._handleResolvable(jsonSerializer);
    }

    @Override
    public Object includeFilterInstance(BeanPropertyDefinition beanPropertyDefinition, Class<?> clazz) {
        Object object;
        if (clazz == null) {
            return null;
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        Object object2 = object = handlerInstantiator == null ? null : handlerInstantiator.includeFilterInstance(this._config, beanPropertyDefinition, clazz);
        if (object == null) {
            object = ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return object;
    }

    @Override
    public boolean includeFilterSuppressNulls(Object object) throws JsonMappingException {
        if (object == null) {
            return true;
        }
        try {
            return object.equals(null);
        }
        catch (Exception exception) {
            String string = String.format("Problem determining whether filter of type '%s' should filter out `null` values: (%s) %s", object.getClass().getName(), exception.getClass().getName(), ClassUtil.exceptionMessage(exception));
            this.reportBadDefinition(object.getClass(), string, (Throwable)exception);
            return false;
        }
    }

    public abstract DefaultSerializerProvider withCaches(CacheProvider var1);

    @Override
    public WritableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator) {
        Object object2;
        if (this._seenObjectIds == null) {
            this._seenObjectIds = this._createObjectIdMap();
        } else {
            object2 = this._seenObjectIds.get(object);
            if (object2 != null) {
                return object2;
            }
        }
        object2 = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int n2 = this._objectIdGenerators.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ObjectIdGenerator<?> objectIdGenerator2 = this._objectIdGenerators.get(i2);
                if (!objectIdGenerator2.canUseFor(objectIdGenerator)) continue;
                object2 = objectIdGenerator2;
                break;
            }
        }
        if (object2 == null) {
            object2 = objectIdGenerator.newForSerialization(this);
            this._objectIdGenerators.add((ObjectIdGenerator<?>)object2);
        }
        WritableObjectId writableObjectId = new WritableObjectId((ObjectIdGenerator<?>)object2);
        this._seenObjectIds.put(object, writableObjectId);
        return writableObjectId;
    }

    protected Map<Object, WritableObjectId> _createObjectIdMap() {
        if (this.isEnabled(SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID)) {
            return new HashMap<Object, WritableObjectId>();
        }
        return new IdentityHashMap<Object, WritableObjectId>();
    }

    public boolean hasSerializerFor(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        if (clazz == Object.class && !this._config.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            return true;
        }
        try {
            JsonSerializer<Object> jsonSerializer = this._findExplicitUntypedSerializer(clazz);
            return jsonSerializer != null;
        }
        catch (JsonMappingException jsonMappingException) {
            if (atomicReference != null) {
                atomicReference.set(jsonMappingException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (atomicReference == null) {
                throw runtimeException;
            }
            atomicReference.set(runtimeException);
        }
        return false;
    }

    @Override
    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        Class<?> clazz = object.getClass();
        JsonSerializer<Object> jsonSerializer = this.findTypedValueSerializer(clazz, true, null);
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                this._serialize(jsonGenerator, object, jsonSerializer, this._config.findRootName(clazz));
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException {
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (!javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        JsonSerializer<Object> jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                this._serialize(jsonGenerator, object, jsonSerializer, this._config.findRootName(javaType));
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException {
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                propertyName = javaType == null ? this._config.findRootName(object.getClass()) : this._config.findRootName(javaType);
                this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) throws IOException {
        boolean bl2;
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if (jsonSerializer == null) {
            jsonSerializer = javaType != null && javaType.isContainerType() ? this.findValueSerializer(javaType, null) : this.findValueSerializer(object.getClass(), null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            bl2 = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl2) {
                jsonGenerator.writeStartObject();
                PropertyName propertyName2 = this._config.findRootName(object.getClass());
                jsonGenerator.writeFieldName(propertyName2.simpleAsEncoded(this._config));
            }
        } else if (propertyName.isEmpty()) {
            bl2 = false;
        } else {
            bl2 = true;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.getSimpleName());
        }
        try {
            jsonSerializer.serializeWithType(object, jsonGenerator, this, typeSerializer);
            if (bl2) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private final void _serialize(JsonGenerator jsonGenerator, Object object, JsonSerializer<Object> jsonSerializer, PropertyName propertyName) throws IOException {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.simpleAsEncoded(this._config));
            jsonSerializer.serialize(object, jsonGenerator, this);
            jsonGenerator.writeEndObject();
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private final void _serialize(JsonGenerator jsonGenerator, Object object, JsonSerializer<Object> jsonSerializer) throws IOException {
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    protected void _serializeNull(JsonGenerator jsonGenerator) throws IOException {
        JsonSerializer<Object> jsonSerializer = this.getDefaultNullValueSerializer();
        try {
            jsonSerializer.serialize(null, jsonGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private IOException _wrapAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        String string = ClassUtil.exceptionMessage(exception);
        if (string == null) {
            string = "[no message for " + exception.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)exception);
    }

    public int cachedSerializersCount() {
        return this._serializerCache.size();
    }

    public void flushCachedSerializers() {
        this._serializerCache.flush();
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        jsonFormatVisitorWrapper.setProvider(this);
        this.findValueSerializer(javaType, null).acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        JsonNode jsonNode;
        JsonSerializer<Object> jsonSerializer = this.findValueSerializer(clazz, null);
        JsonNode jsonNode2 = jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(this, null) : JsonSchema.getDefaultSchemaNode();
        if (!(jsonNode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " would not be serialized as a JSON object and therefore has no schema");
        }
        return new JsonSchema((ObjectNode)jsonNode);
    }

    public static final class Impl
    extends DefaultSerializerProvider {
        private static final long serialVersionUID = 1L;

        public Impl() {
        }

        public Impl(Impl impl) {
            super(impl);
        }

        protected Impl(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            super(serializerProvider, serializationConfig, serializerFactory);
        }

        protected Impl(Impl impl, CacheProvider cacheProvider) {
            super(impl, cacheProvider);
        }

        @Override
        public DefaultSerializerProvider copy() {
            return new Impl(this);
        }

        @Override
        public Impl createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            return new Impl(this, serializationConfig, serializerFactory);
        }

        @Override
        public DefaultSerializerProvider withCaches(CacheProvider cacheProvider) {
            return new Impl(this, cacheProvider);
        }
    }
}

