/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.Serializers;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.ArrayType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.ClassKey;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.CollectionLikeType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.CollectionType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.MapLikeType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.MapType;

public class SimpleSerializers
extends Serializers.Base
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected HashMap<ClassKey, JsonSerializer<?>> _classMappings = null;
    protected HashMap<ClassKey, JsonSerializer<?>> _interfaceMappings = null;
    protected boolean _hasEnumSerializer = false;

    public SimpleSerializers() {
    }

    public SimpleSerializers(List<JsonSerializer<?>> list) {
        this.addSerializers(list);
    }

    public void addSerializer(JsonSerializer<?> jsonSerializer) {
        Class<?> clazz = jsonSerializer.handledType();
        if (clazz == null || clazz == Object.class) {
            throw new IllegalArgumentException("JsonSerializer of type " + jsonSerializer.getClass().getName() + " does not define valid handledType() -- must either register with method that takes type argument  or make serializer extend 'macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.StdSerializer'");
        }
        this._addSerializer(clazz, jsonSerializer);
    }

    public <T> void addSerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        this._addSerializer(clazz, jsonSerializer);
    }

    public void addSerializers(List<JsonSerializer<?>> list) {
        for (JsonSerializer<?> jsonSerializer : list) {
            this.addSerializer(jsonSerializer);
        }
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        ClassKey classKey = new ClassKey(clazz);
        JsonSerializer<?> jsonSerializer = null;
        if (clazz.isInterface()) {
            if (this._interfaceMappings != null && (jsonSerializer = this._interfaceMappings.get(classKey)) != null) {
                return jsonSerializer;
            }
        } else if (this._classMappings != null) {
            jsonSerializer = this._classMappings.get(classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (this._hasEnumSerializer && javaType.isEnumType()) {
                classKey.reset(Enum.class);
                jsonSerializer = this._classMappings.get(classKey);
                if (jsonSerializer != null) {
                    return jsonSerializer;
                }
            }
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                classKey.reset(clazz2);
                jsonSerializer = this._classMappings.get(classKey);
                if (jsonSerializer == null) continue;
                return jsonSerializer;
            }
        }
        if (this._interfaceMappings != null) {
            jsonSerializer = this._findInterfaceMapping(clazz, classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (!clazz.isInterface()) {
                while ((clazz = clazz.getSuperclass()) != null) {
                    jsonSerializer = this._findInterfaceMapping(clazz, classKey);
                    if (jsonSerializer == null) continue;
                    return jsonSerializer;
                }
            }
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return this.findSerializer(serializationConfig, arrayType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return this.findSerializer(serializationConfig, collectionType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig serializationConfig, CollectionLikeType collectionLikeType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return this.findSerializer(serializationConfig, collectionLikeType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        return this.findSerializer(serializationConfig, mapType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig serializationConfig, MapLikeType mapLikeType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        return this.findSerializer(serializationConfig, mapLikeType, beanDescription);
    }

    protected JsonSerializer<?> _findInterfaceMapping(Class<?> clazz, ClassKey classKey) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            classKey.reset(clazz2);
            JsonSerializer<?> jsonSerializer = this._interfaceMappings.get(classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            jsonSerializer = this._findInterfaceMapping(clazz2, classKey);
            if (jsonSerializer == null) continue;
            return jsonSerializer;
        }
        return null;
    }

    protected void _addSerializer(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        ClassKey classKey = new ClassKey(clazz);
        if (clazz.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(classKey, jsonSerializer);
        } else {
            if (this._classMappings == null) {
                this._classMappings = new HashMap();
            }
            this._classMappings.put(classKey, jsonSerializer);
            if (clazz == Enum.class) {
                this._hasEnumSerializer = true;
            }
        }
    }
}

