/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.KeyDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.Deserializers;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.ArrayType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.ClassKey;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.CollectionLikeType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.CollectionType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.MapLikeType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.MapType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.ReferenceType;

public class SimpleDeserializers
extends Deserializers.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings = null;
    protected boolean _hasEnumDeserializer = false;

    public SimpleDeserializers() {
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        this.addDeserializers(map);
    }

    public <T> void addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        ClassKey classKey = new ClassKey(clazz);
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(classKey, jsonDeserializer);
        if (clazz == Enum.class) {
            this._hasEnumDeserializer = true;
        }
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : map.entrySet()) {
            Class<?> clazz = entry.getKey();
            JsonDeserializer<?> jsonDeserializer = entry.getValue();
            this.addDeserializer(clazz, jsonDeserializer);
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(arrayType);
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return this._find(javaType);
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(collectionType);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(collectionLikeType);
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        JsonDeserializer<?> jsonDeserializer = this._classMappings.get(new ClassKey(clazz));
        if (jsonDeserializer == null && this._hasEnumDeserializer && clazz.isEnum()) {
            jsonDeserializer = this._classMappings.get(new ClassKey(Enum.class));
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(clazz));
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(referenceType);
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(mapType);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._find(mapLikeType);
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return this._classMappings != null && this._classMappings.containsKey(new ClassKey(clazz));
    }

    private final JsonDeserializer<?> _find(JavaType javaType) {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(javaType.getRawClass()));
    }
}

