/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;

public class BasicPolymorphicTypeValidator
extends PolymorphicTypeValidator.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Set<Class<?>> _invalidBaseTypes;
    protected final TypeMatcher[] _baseTypeMatchers;
    protected final NameMatcher[] _subTypeNameMatchers;
    protected final TypeMatcher[] _subClassMatchers;

    protected BasicPolymorphicTypeValidator(Set<Class<?>> set, TypeMatcher[] typeMatcherArray, NameMatcher[] nameMatcherArray, TypeMatcher[] typeMatcherArray2) {
        this._invalidBaseTypes = set;
        this._baseTypeMatchers = typeMatcherArray;
        this._subTypeNameMatchers = nameMatcherArray;
        this._subClassMatchers = typeMatcherArray2;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PolymorphicTypeValidator.Validity validateBaseType(MapperConfig<?> mapperConfig, JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (this._invalidBaseTypes != null && this._invalidBaseTypes.contains(clazz)) {
            return PolymorphicTypeValidator.Validity.DENIED;
        }
        if (this._baseTypeMatchers != null) {
            for (TypeMatcher typeMatcher : this._baseTypeMatchers) {
                if (!typeMatcher.match(mapperConfig, clazz)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator.Validity validateSubClassName(MapperConfig<?> mapperConfig, JavaType javaType, String string) throws JsonMappingException {
        if (this._subTypeNameMatchers != null) {
            for (NameMatcher nameMatcher : this._subTypeNameMatchers) {
                if (!nameMatcher.match(mapperConfig, string)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator.Validity validateSubType(MapperConfig<?> mapperConfig, JavaType javaType, JavaType javaType2) throws JsonMappingException {
        if (this._subClassMatchers != null) {
            Class<?> clazz = javaType2.getRawClass();
            for (TypeMatcher typeMatcher : this._subClassMatchers) {
                if (!typeMatcher.match(mapperConfig, clazz)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    public static class Builder {
        protected Set<Class<?>> _invalidBaseTypes;
        protected List<TypeMatcher> _baseTypeMatchers;
        protected List<NameMatcher> _subTypeNameMatchers;
        protected List<TypeMatcher> _subTypeClassMatchers;

        protected Builder() {
        }

        public Builder allowIfBaseType(final Class<?> clazz) {
            return this._appendBaseMatcher(new TypeMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, Class<?> clazz2) {
                    return clazz.isAssignableFrom(clazz2);
                }
            });
        }

        public Builder allowIfBaseType(final Pattern pattern) {
            return this._appendBaseMatcher(new TypeMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return pattern.matcher(clazz.getName()).matches();
                }
            });
        }

        public Builder allowIfBaseType(final String string) {
            return this._appendBaseMatcher(new TypeMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return clazz.getName().startsWith(string);
                }
            });
        }

        public Builder allowIfBaseType(TypeMatcher typeMatcher) {
            return this._appendBaseMatcher(typeMatcher);
        }

        public Builder denyForExactBaseType(Class<?> clazz) {
            if (this._invalidBaseTypes == null) {
                this._invalidBaseTypes = new HashSet();
            }
            this._invalidBaseTypes.add(clazz);
            return this;
        }

        public Builder allowIfSubType(final Class<?> clazz) {
            return this._appendSubClassMatcher(new TypeMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, Class<?> clazz2) {
                    return clazz.isAssignableFrom(clazz2);
                }
            });
        }

        public Builder allowIfSubType(final Pattern pattern) {
            return this._appendSubNameMatcher(new NameMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, String string) {
                    return pattern.matcher(string).matches();
                }
            });
        }

        public Builder allowIfSubType(final String string) {
            return this._appendSubNameMatcher(new NameMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, String string2) {
                    return string2.startsWith(string);
                }
            });
        }

        public Builder allowIfSubType(TypeMatcher typeMatcher) {
            return this._appendSubClassMatcher(typeMatcher);
        }

        public Builder allowIfSubTypeIsArray() {
            return this._appendSubClassMatcher(new TypeMatcher(){

                @Override
                public boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return clazz.isArray();
                }
            });
        }

        public BasicPolymorphicTypeValidator build() {
            return new BasicPolymorphicTypeValidator(this._invalidBaseTypes, this._baseTypeMatchers == null ? null : this._baseTypeMatchers.toArray(new TypeMatcher[0]), this._subTypeNameMatchers == null ? null : this._subTypeNameMatchers.toArray(new NameMatcher[0]), this._subTypeClassMatchers == null ? null : this._subTypeClassMatchers.toArray(new TypeMatcher[0]));
        }

        protected Builder _appendBaseMatcher(TypeMatcher typeMatcher) {
            if (this._baseTypeMatchers == null) {
                this._baseTypeMatchers = new ArrayList<TypeMatcher>();
            }
            this._baseTypeMatchers.add(typeMatcher);
            return this;
        }

        protected Builder _appendSubNameMatcher(NameMatcher nameMatcher) {
            if (this._subTypeNameMatchers == null) {
                this._subTypeNameMatchers = new ArrayList<NameMatcher>();
            }
            this._subTypeNameMatchers.add(nameMatcher);
            return this;
        }

        protected Builder _appendSubClassMatcher(TypeMatcher typeMatcher) {
            if (this._subTypeClassMatchers == null) {
                this._subTypeClassMatchers = new ArrayList<TypeMatcher>();
            }
            this._subTypeClassMatchers.add(typeMatcher);
            return this;
        }
    }

    public static abstract class NameMatcher {
        public abstract boolean match(MapperConfig<?> var1, String var2);
    }

    public static abstract class TypeMatcher {
        public abstract boolean match(MapperConfig<?> var1, Class<?> var2);
    }
}

