/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.Annotations;

public final class AnnotationMap
implements Annotations {
    protected HashMap<Class<?>, Annotation> _annotations;

    public AnnotationMap() {
    }

    public static AnnotationMap of(Class<?> clazz, Annotation annotation) {
        HashMap hashMap = new HashMap(4);
        hashMap.put(clazz, annotation);
        return new AnnotationMap(hashMap);
    }

    AnnotationMap(HashMap<Class<?>, Annotation> hashMap) {
        this._annotations = hashMap;
    }

    @Override
    public <A extends Annotation> A get(Class<A> clazz) {
        if (this._annotations == null) {
            return null;
        }
        return (A)this._annotations.get(clazz);
    }

    @Override
    public boolean has(Class<?> clazz) {
        if (this._annotations == null) {
            return false;
        }
        return this._annotations.containsKey(clazz);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        if (this._annotations != null) {
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this._annotations.containsKey(classArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<Annotation> annotations() {
        if (this._annotations == null || this._annotations.size() == 0) {
            return Collections.emptyList();
        }
        return this._annotations.values();
    }

    public static AnnotationMap merge(AnnotationMap annotationMap, AnnotationMap annotationMap2) {
        if (annotationMap == null || annotationMap._annotations == null || annotationMap._annotations.isEmpty()) {
            return annotationMap2;
        }
        if (annotationMap2 == null || annotationMap2._annotations == null || annotationMap2._annotations.isEmpty()) {
            return annotationMap;
        }
        HashMap hashMap = new HashMap();
        for (Annotation annotation : annotationMap2._annotations.values()) {
            hashMap.put(annotation.annotationType(), annotation);
        }
        for (Annotation annotation : annotationMap._annotations.values()) {
            hashMap.put(annotation.annotationType(), annotation);
        }
        return new AnnotationMap(hashMap);
    }

    @Override
    public int size() {
        return this._annotations == null ? 0 : this._annotations.size();
    }

    public boolean addIfNotPresent(Annotation annotation) {
        if (this._annotations == null || !this._annotations.containsKey(annotation.annotationType())) {
            this._add(annotation);
            return true;
        }
        return false;
    }

    public boolean add(Annotation annotation) {
        return this._add(annotation);
    }

    public String toString() {
        if (this._annotations == null) {
            return "[null]";
        }
        return this._annotations.toString();
    }

    protected final boolean _add(Annotation annotation) {
        Annotation annotation2;
        if (this._annotations == null) {
            this._annotations = new HashMap();
        }
        return (annotation2 = this._annotations.put(annotation.annotationType(), annotation)) == null || !annotation2.equals(annotation);
    }
}

