/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.TypeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.Converter;

public abstract class JavaUtilCollectionsDeserializers {
    private static final int TYPE_SINGLETON_SET = 1;
    private static final int TYPE_SINGLETON_LIST = 2;
    private static final int TYPE_SINGLETON_MAP = 3;
    private static final int TYPE_UNMODIFIABLE_SET = 4;
    private static final int TYPE_UNMODIFIABLE_LIST = 5;
    private static final int TYPE_UNMODIFIABLE_MAP = 6;
    private static final int TYPE_SYNC_SET = 7;
    private static final int TYPE_SYNC_COLLECTION = 8;
    private static final int TYPE_SYNC_LIST = 9;
    private static final int TYPE_SYNC_MAP = 10;
    public static final int TYPE_AS_LIST = 11;
    private static final String PREFIX_JAVA_UTIL_COLLECTIONS = "java.util.Collections$";
    private static final String PREFIX_JAVA_UTIL_ARRAYS = "java.util.Arrays$";
    private static final String PREFIX_JAVA_UTIL_IMMUTABLE_COLL = "java.util.ImmutableCollections$";

    public static JsonDeserializer<?> findForCollection(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        String string = javaType.getRawClass().getName();
        if (!string.startsWith("java.util.")) {
            return null;
        }
        String string2 = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName(string);
        if (string2 != null) {
            JavaUtilCollectionsConverter javaUtilCollectionsConverter = null;
            String string3 = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(string2);
            if (string3 != null) {
                if (string3.endsWith("Set")) {
                    javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(4, javaType, Set.class);
                } else if (string3.endsWith("List")) {
                    javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(5, javaType, List.class);
                }
            } else {
                string3 = JavaUtilCollectionsDeserializers._findSingletonTypeName(string2);
                if (string3 != null) {
                    if (string3.endsWith("Set")) {
                        javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(1, javaType, Set.class);
                    } else if (string3.endsWith("List")) {
                        javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(2, javaType, List.class);
                    }
                } else {
                    string3 = JavaUtilCollectionsDeserializers._findSyncTypeName(string2);
                    if (string3 != null) {
                        if (string3.endsWith("Set")) {
                            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(7, javaType, Set.class);
                        } else if (string3.endsWith("List")) {
                            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(9, javaType, List.class);
                        } else if (string3.endsWith("Collection")) {
                            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(8, javaType, Collection.class);
                        }
                    }
                }
            }
            return javaUtilCollectionsConverter == null ? null : new StdDelegatingDeserializer<Object>(javaUtilCollectionsConverter);
        }
        string2 = JavaUtilCollectionsDeserializers._findUtilArrayTypeName(string);
        if (string2 != null) {
            if (string2.contains("List")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(11, javaType, List.class));
            }
            return null;
        }
        string2 = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName(string);
        if (string2 != null) {
            if (string2.contains("List")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(11, javaType, List.class));
            }
            if (string2.contains("Set")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(4, javaType, Set.class));
            }
            return null;
        }
        return null;
    }

    public static JsonDeserializer<?> findForMap(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        String string = javaType.getRawClass().getName();
        JavaUtilCollectionsConverter javaUtilCollectionsConverter = null;
        String string2 = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName(string);
        if (string2 != null) {
            String string3 = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(string2);
            if (string3 != null) {
                if (string3.contains("Map")) {
                    javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(6, javaType, Map.class);
                }
            } else {
                string3 = JavaUtilCollectionsDeserializers._findSingletonTypeName(string2);
                if (string3 != null) {
                    if (string3.contains("Map")) {
                        javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(3, javaType, Map.class);
                    }
                } else {
                    string3 = JavaUtilCollectionsDeserializers._findSyncTypeName(string2);
                    if (string3 != null && string3.contains("Map")) {
                        javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(10, javaType, Map.class);
                    }
                }
            }
        } else {
            string2 = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName(string);
            if (string2 != null && string2.contains("Map")) {
                javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(6, javaType, Map.class);
            }
        }
        return javaUtilCollectionsConverter == null ? null : new StdDelegatingDeserializer(javaUtilCollectionsConverter);
    }

    static JavaUtilCollectionsConverter converter(int n2, JavaType javaType, Class<?> clazz) {
        return new JavaUtilCollectionsConverter(n2, javaType.findSuperType(clazz));
    }

    private static String _findUtilArrayTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_ARRAYS)) {
            return string.substring(PREFIX_JAVA_UTIL_ARRAYS.length());
        }
        return null;
    }

    private static String _findUtilCollectionsTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_COLLECTIONS)) {
            return string.substring(PREFIX_JAVA_UTIL_COLLECTIONS.length());
        }
        return null;
    }

    private static String _findUtilCollectionsImmutableTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_IMMUTABLE_COLL)) {
            return string.substring(PREFIX_JAVA_UTIL_IMMUTABLE_COLL.length());
        }
        return null;
    }

    private static String _findSingletonTypeName(String string) {
        return string.startsWith("Singleton") ? string.substring(9) : null;
    }

    private static String _findSyncTypeName(String string) {
        return string.startsWith("Synchronized") ? string.substring(12) : null;
    }

    private static String _findUnmodifiableTypeName(String string) {
        return string.startsWith("Unmodifiable") ? string.substring(12) : null;
    }

    private static class JavaUtilCollectionsConverter
    implements Converter<Object, Object> {
        private final JavaType _inputType;
        private final int _kind;

        JavaUtilCollectionsConverter(int n2, JavaType javaType) {
            this._inputType = javaType;
            this._kind = n2;
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            switch (this._kind) {
                case 1: {
                    Set set = (Set)object;
                    this._checkSingleton(set.size());
                    return Collections.singleton(set.iterator().next());
                }
                case 2: {
                    List list = (List)object;
                    this._checkSingleton(list.size());
                    return Collections.singletonList(list.get(0));
                }
                case 3: {
                    Map map = (Map)object;
                    this._checkSingleton(map.size());
                    Map.Entry entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
                case 4: {
                    return Collections.unmodifiableSet((Set)object);
                }
                case 5: {
                    return Collections.unmodifiableList((List)object);
                }
                case 6: {
                    return Collections.unmodifiableMap((Map)object);
                }
                case 7: {
                    return Collections.synchronizedSet((Set)object);
                }
                case 9: {
                    return Collections.synchronizedList((List)object);
                }
                case 8: {
                    return Collections.synchronizedCollection((Collection)object);
                }
                case 10: {
                    return Collections.synchronizedMap((Map)object);
                }
            }
            return object;
        }

        @Override
        public JavaType getInputType(TypeFactory typeFactory) {
            return this._inputType;
        }

        @Override
        public JavaType getOutputType(TypeFactory typeFactory) {
            return this._inputType;
        }

        private void _checkSingleton(int n2) {
            if (n2 != 1) {
                throw new IllegalArgumentException("Can not deserialize Singleton container from " + n2 + " entries");
            }
        }
    }
}

