/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser;

import java.io.IOException;
import java.lang.annotation.Annotation;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JacksonInject;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyMetadata;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyName;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.NullValueProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.Annotations;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public class CreatorProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedParameter _annotated;
    protected final JacksonInject.Value _injectableValue;
    protected SettableBeanProperty _fallbackSetter;
    protected final int _creatorIndex;
    protected boolean _ignorable;

    protected CreatorProperty(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, JacksonInject.Value value, PropertyMetadata propertyMetadata) {
        super(propertyName, javaType, propertyName2, typeDeserializer, annotations, propertyMetadata);
        this._annotated = annotatedParameter;
        this._creatorIndex = n2;
        this._injectableValue = value;
        this._fallbackSetter = null;
    }

    @Deprecated
    public CreatorProperty(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, Object object, PropertyMetadata propertyMetadata) {
        this(propertyName, javaType, propertyName2, typeDeserializer, annotations, annotatedParameter, n2, object == null ? null : JacksonInject.Value.construct(object, null), propertyMetadata);
    }

    public static CreatorProperty construct(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, JacksonInject.Value value, PropertyMetadata propertyMetadata) {
        return new CreatorProperty(propertyName, javaType, propertyName2, typeDeserializer, annotations, annotatedParameter, n2, value, propertyMetadata);
    }

    protected CreatorProperty(CreatorProperty creatorProperty, PropertyName propertyName) {
        super(creatorProperty, propertyName);
        this._annotated = creatorProperty._annotated;
        this._injectableValue = creatorProperty._injectableValue;
        this._fallbackSetter = creatorProperty._fallbackSetter;
        this._creatorIndex = creatorProperty._creatorIndex;
        this._ignorable = creatorProperty._ignorable;
    }

    protected CreatorProperty(CreatorProperty creatorProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(creatorProperty, jsonDeserializer, nullValueProvider);
        this._annotated = creatorProperty._annotated;
        this._injectableValue = creatorProperty._injectableValue;
        this._fallbackSetter = creatorProperty._fallbackSetter;
        this._creatorIndex = creatorProperty._creatorIndex;
        this._ignorable = creatorProperty._ignorable;
    }

    @Override
    public SettableBeanProperty withName(PropertyName propertyName) {
        return new CreatorProperty(this, propertyName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._valueDeserializer == jsonDeserializer) {
            return this;
        }
        NullValueProvider nullValueProvider = this._valueDeserializer == this._nullProvider ? jsonDeserializer : this._nullProvider;
        return new CreatorProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        return new CreatorProperty(this, this._valueDeserializer, nullValueProvider);
    }

    @Override
    public void fixAccess(DeserializationConfig deserializationConfig) {
        if (this._fallbackSetter != null) {
            this._fallbackSetter.fixAccess(deserializationConfig);
        }
    }

    public void setFallbackSetter(SettableBeanProperty settableBeanProperty) {
        this._fallbackSetter = settableBeanProperty;
    }

    @Override
    public void markAsIgnorable() {
        this._ignorable = true;
    }

    @Override
    public boolean isIgnorable() {
        return this._ignorable;
    }

    @Deprecated
    public Object findInjectableValue(DeserializationContext deserializationContext, Object object) throws JsonMappingException {
        if (this._injectableValue == null) {
            deserializationContext.reportBadDefinition(ClassUtil.classOf(object), String.format("Property %s (type %s) has no injectable value id configured", ClassUtil.name(this.getName()), ClassUtil.classNameOf(this)));
        }
        return deserializationContext.findInjectableValue(this._injectableValue.getId(), this, object);
    }

    @Deprecated
    public void inject(DeserializationContext deserializationContext, Object object) throws IOException {
        this.set(object, this.findInjectableValue(deserializationContext, object));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        if (this._annotated == null) {
            return null;
        }
        return this._annotated.getAnnotation(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public int getCreatorIndex() {
        return this._creatorIndex;
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        this._verifySetter();
        this._fallbackSetter.set(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        this._verifySetter();
        return this._fallbackSetter.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public void set(Object object, Object object2) throws IOException {
        this._verifySetter();
        this._fallbackSetter.set(object, object2);
    }

    @Override
    public Object setAndReturn(Object object, Object object2) throws IOException {
        this._verifySetter();
        return this._fallbackSetter.setAndReturn(object, object2);
    }

    @Override
    public PropertyMetadata getMetadata() {
        PropertyMetadata propertyMetadata = super.getMetadata();
        if (this._fallbackSetter != null) {
            return propertyMetadata.withMergeInfo(this._fallbackSetter.getMetadata().getMergeInfo());
        }
        return propertyMetadata;
    }

    @Override
    public Object getInjectableValueId() {
        return this._injectableValue == null ? null : this._injectableValue.getId();
    }

    @Override
    public boolean isInjectionOnly() {
        return this._injectableValue != null && !this._injectableValue.willUseInput(true);
    }

    @Override
    public String toString() {
        return "[creator property, name " + ClassUtil.name(this.getName()) + "; inject id '" + this.getInjectableValueId() + "']";
    }

    private final void _verifySetter() throws IOException {
        if (this._fallbackSetter == null) {
            this._reportMissingSetter(null, null);
        }
    }

    private void _reportMissingSetter(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = "No fallback setter/field defined for creator property " + ClassUtil.name(this.getName());
        if (deserializationContext == null) {
            throw InvalidDefinitionException.from(jsonParser, string, this.getType());
        }
        deserializationContext.reportBadDefinition(this.getType(), string);
    }
}

