/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser;

import java.math.BigInteger;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.BigSignificand;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.FftMultiplier;

class ParseDigitsTaskByteArray {
    private ParseDigitsTaskByteArray() {
    }

    static BigInteger parseDigitsIterative(byte[] byArray, int n2, int n3) {
        assert (byArray != null) : "str==null";
        int n4 = n3 - n2;
        BigSignificand bigSignificand = new BigSignificand(FastIntegerMath.estimateNumBits(n4));
        int n5 = n2 + (n4 & 7);
        int n6 = FastDoubleSwar.tryToParseUpTo7Digits(byArray, n2, n5);
        boolean bl2 = n6 >= 0;
        bigSignificand.add(n6);
        for (n2 = n5; n2 < n3; n2 += 8) {
            int n7 = FastDoubleSwar.tryToParseEightDigits(byArray, n2);
            bl2 &= n7 >= 0;
            bigSignificand.fma(100000000, n7);
        }
        if (!bl2) {
            throw new NumberFormatException("illegal syntax");
        }
        return bigSignificand.toBigInteger();
    }

    static BigInteger parseDigitsRecursive(byte[] byArray, int n2, int n3, Map<Integer, BigInteger> map, int n4) {
        assert (byArray != null) : "str==null";
        assert (map != null) : "powersOfTen==null";
        int n5 = n3 - n2;
        if (n5 <= n4) {
            return ParseDigitsTaskByteArray.parseDigitsIterative(byArray, n2, n3);
        }
        int n6 = FastIntegerMath.splitFloor16(n2, n3);
        BigInteger bigInteger = ParseDigitsTaskByteArray.parseDigitsRecursive(byArray, n2, n6, map, n4);
        BigInteger bigInteger2 = ParseDigitsTaskByteArray.parseDigitsRecursive(byArray, n6, n3, map, n4);
        bigInteger = FftMultiplier.multiply(bigInteger, map.get(n3 - n6));
        return bigInteger2.add(bigInteger);
    }
}

