/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser;

import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaFloatBitsFromByteArray;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaFloatBitsFromCharArray;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaFloatBitsFromCharSequence;

public class JavaFloatParser {
    private static final JavaFloatBitsFromByteArray BYTE_ARRAY_PARSER = new JavaFloatBitsFromByteArray();
    private static final JavaFloatBitsFromCharArray CHAR_ARRAY_PARSER = new JavaFloatBitsFromCharArray();
    private static final JavaFloatBitsFromCharSequence CHAR_SEQUENCE_PARSER = new JavaFloatBitsFromCharSequence();

    private JavaFloatParser() {
    }

    public static float parseFloat(CharSequence charSequence) throws NumberFormatException {
        return JavaFloatParser.parseFloat(charSequence, 0, charSequence.length());
    }

    public static float parseFloat(CharSequence charSequence, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_SEQUENCE_PARSER.parseFloatingPointLiteral(charSequence, n2, n3);
        return Float.intBitsToFloat((int)l2);
    }

    public static float parseFloat(byte[] byArray) throws NumberFormatException {
        return JavaFloatParser.parseFloat(byArray, 0, byArray.length);
    }

    public static float parseFloat(byte[] byArray, int n2, int n3) throws NumberFormatException {
        long l2 = BYTE_ARRAY_PARSER.parseFloatingPointLiteral(byArray, n2, n3);
        return Float.intBitsToFloat((int)l2);
    }

    public static float parseFloat(char[] cArray) throws NumberFormatException {
        return JavaFloatParser.parseFloat(cArray, 0, cArray.length);
    }

    public static float parseFloat(char[] cArray, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_ARRAY_PARSER.parseFloatingPointLiteral(cArray, n2, n3);
        return Float.intBitsToFloat((int)l2);
    }
}

