/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.io;

import java.math.BigDecimal;
import java.util.Arrays;

public final class BigDecimalParser {
    private final char[] chars;

    BigDecimalParser(char[] cArray) {
        this.chars = cArray;
    }

    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        if (n2 > 0 || n3 != cArray.length) {
            cArray = Arrays.copyOfRange(cArray, n2, n2 + n3);
        }
        return BigDecimalParser.parse(cArray);
    }

    public static BigDecimal parse(char[] cArray) {
        int n2 = cArray.length;
        try {
            if (n2 < 500) {
                return new BigDecimal(cArray);
            }
            return new BigDecimalParser(cArray).parseBigDecimal(n2 / 10);
        }
        catch (NumberFormatException numberFormatException) {
            String string = numberFormatException.getMessage();
            if (string == null) {
                string = "Not a valid number representation";
            }
            throw new NumberFormatException("Value \"" + new String(cArray) + "\" can not be represented as `java.math.BigDecimal`, reason: " + string);
        }
    }

    private BigDecimal parseBigDecimal(int n2) {
        Object object;
        int n3;
        int n4;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = this.chars.length;
        block6: for (n4 = 0; n4 < n9; ++n4) {
            n3 = this.chars[n4];
            switch (n3) {
                case 43: {
                    if (n6 >= 0) {
                        if (bl3) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl3 = true;
                        continue block6;
                    }
                    if (bl2) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl2 = true;
                    n5 = n4 + 1;
                    continue block6;
                }
                case 45: {
                    if (n6 >= 0) {
                        if (bl3) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl3 = true;
                        continue block6;
                    }
                    if (bl2) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl2 = true;
                    bl4 = true;
                    n5 = n4 + 1;
                    continue block6;
                }
                case 69: 
                case 101: {
                    if (n6 >= 0) {
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    n6 = n4;
                    continue block6;
                }
                case 46: {
                    if (n7 >= 0) {
                        throw new NumberFormatException("Multiple decimal points");
                    }
                    n7 = n4;
                    continue block6;
                }
                default: {
                    if (n7 < 0 || n6 != -1) continue block6;
                    ++n8;
                }
            }
        }
        n3 = 0;
        if (n6 >= 0) {
            n4 = n6;
            object = new String(this.chars, n6 + 1, n9 - n6 - 1);
            n3 = Integer.parseInt((String)object);
            n8 = this.adjustScale(n8, n3);
        } else {
            n4 = n9;
        }
        if (n7 >= 0) {
            int n10 = n7 - n5;
            BigDecimal bigDecimal = this.toBigDecimalRec(n5, n10, n3, n2);
            int n11 = n4 - n7 - 1;
            BigDecimal bigDecimal2 = this.toBigDecimalRec(n7 + 1, n11, n3 - n11, n2);
            object = bigDecimal.add(bigDecimal2);
        } else {
            object = this.toBigDecimalRec(n5, n4 - n5, n3, n2);
        }
        if (n8 != 0) {
            object = ((BigDecimal)object).setScale(n8);
        }
        if (bl4) {
            object = ((BigDecimal)object).negate();
        }
        return object;
    }

    private int adjustScale(int n2, long l2) {
        long l3 = (long)n2 - l2;
        if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range: " + l3 + " while adjusting scale " + n2 + " to exponent " + l2);
        }
        return (int)l3;
    }

    private BigDecimal toBigDecimalRec(int n2, int n3, int n4, int n5) {
        if (n3 > n5) {
            int n6 = n3 / 2;
            BigDecimal bigDecimal = this.toBigDecimalRec(n2, n6, n4 + n3 - n6, n5);
            BigDecimal bigDecimal2 = this.toBigDecimalRec(n2 + n6, n3 - n6, n4, n5);
            return bigDecimal.add(bigDecimal2);
        }
        return n3 == 0 ? BigDecimal.ZERO : new BigDecimal(this.chars, n2, n3).movePointRight(n4);
    }
}

