/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json.implementation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriteContext;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.json.JsonWriteFeature;

public final class DefaultJsonWriter
extends JsonWriter {
    private static final JsonFactory FACTORY = JsonFactory.builder().build();
    private final JsonGenerator generator;
    private JsonWriteContext context = JsonWriteContext.ROOT;

    public static JsonWriter toStream(OutputStream outputStream, JsonOptions jsonOptions) throws IOException {
        Objects.requireNonNull(outputStream, "'json' cannot be null.");
        return new DefaultJsonWriter(FACTORY.createGenerator(outputStream), jsonOptions);
    }

    public static JsonWriter toWriter(Writer writer, JsonOptions jsonOptions) throws IOException {
        Objects.requireNonNull(writer, "'json' cannot be null.");
        return new DefaultJsonWriter(FACTORY.createGenerator(writer), jsonOptions);
    }

    private DefaultJsonWriter(JsonGenerator jsonGenerator, JsonOptions jsonOptions) {
        this.generator = jsonGenerator;
        this.generator.configure(JsonWriteFeature.WRITE_NAN_AS_STRINGS.mappedFeature(), jsonOptions.isNonNumericNumbersSupported());
    }

    @Override
    public JsonWriter flush() throws IOException {
        this.generator.flush();
        return this;
    }

    @Override
    public JsonWriter writeStartObject() throws IOException {
        this.context.validateToken(JsonToken.START_OBJECT);
        this.generator.writeStartObject();
        this.context = this.context.updateContext(JsonToken.START_OBJECT);
        return this;
    }

    @Override
    public JsonWriter writeEndObject() throws IOException {
        this.context.validateToken(JsonToken.END_OBJECT);
        this.generator.writeEndObject();
        this.context = this.context.updateContext(JsonToken.END_OBJECT);
        return this;
    }

    @Override
    public JsonWriter writeStartArray() throws IOException {
        this.context.validateToken(JsonToken.START_ARRAY);
        this.generator.writeStartArray();
        this.context = this.context.updateContext(JsonToken.START_ARRAY);
        return this;
    }

    @Override
    public JsonWriter writeEndArray() throws IOException {
        this.context.validateToken(JsonToken.END_ARRAY);
        this.generator.writeEndArray();
        this.context = this.context.updateContext(JsonToken.END_ARRAY);
        return this;
    }

    @Override
    public JsonWriter writeFieldName(String string) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        this.context.validateToken(JsonToken.FIELD_NAME);
        this.generator.writeFieldName(string);
        this.context = this.context.updateContext(JsonToken.FIELD_NAME);
        return this;
    }

    @Override
    public JsonWriter writeBinary(byte[] byArray) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        if (byArray == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(byArray);
        }
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    @Override
    public JsonWriter writeBoolean(boolean bl2) throws IOException {
        this.context.validateToken(JsonToken.BOOLEAN);
        this.generator.writeBoolean(bl2);
        this.context = this.context.updateContext(JsonToken.BOOLEAN);
        return this;
    }

    @Override
    public JsonWriter writeDouble(double d2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(d2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeFloat(float f2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(f2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeInt(int n2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(n2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeLong(long l2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(l2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeNull() throws IOException {
        this.context.validateToken(JsonToken.NULL);
        this.generator.writeNull();
        this.context = this.context.updateContext(JsonToken.NULL);
        return this;
    }

    @Override
    public JsonWriter writeString(String string) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeString(string);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    @Override
    public JsonWriter writeRawValue(String string) throws IOException {
        Objects.requireNonNull(string, "'value' cannot be null.");
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeRawValue(string);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    @Override
    public JsonWriteContext getWriteContext() {
        return this.context;
    }

    @Override
    public void close() throws IOException {
        if (this.context != JsonWriteContext.COMPLETED) {
            throw new IllegalStateException("Writing of the JSON object must be completed before the writer can be closed. Current writing state is '" + (Object)((Object)this.context.getWriteState()) + "'.");
        }
        this.generator.flush();
        this.generator.close();
    }
}

