/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;

public final class ValidationUtil {
    public static void validate(String string, ClientLogger clientLogger, String string2, Object object, String string3, Object object2) {
        String string4 = "";
        if (object == null) {
            string4 = string4 + string2;
        }
        if (object2 == null) {
            string4 = string4 + (string4.isEmpty() ? string3 : ", " + string3);
        }
        if (!string4.isEmpty()) {
            throw clientLogger.logExceptionAsWarning(new IllegalArgumentException("Must provide non-null values for " + string4 + " properties in " + string));
        }
    }

    public static void validate(String string, ClientLogger clientLogger, String string2, Object object, String string3, Object object2, String string4, Object object3) {
        String string5 = "";
        if (object == null) {
            string5 = string5 + string2;
        }
        if (object2 == null) {
            string5 = string5 + (string5.isEmpty() ? string3 : ", " + string3);
        }
        if (object3 == null) {
            string5 = string5 + (string5.isEmpty() ? string4 : ", " + string4);
        }
        if (!string5.isEmpty()) {
            throw clientLogger.logExceptionAsWarning(new IllegalArgumentException("Must provide non-null values for " + string5 + " properties in " + string));
        }
    }

    public static void validateAuthHost(String string, ClientLogger clientLogger) {
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw clientLogger.logExceptionAsError(new IllegalArgumentException("Must provide a valid URI for authority host.", uRISyntaxException));
        }
        if (!string.startsWith("https")) {
            throw clientLogger.logExceptionAsError(new IllegalArgumentException("Authority host must use https scheme."));
        }
    }

    public static void validateTenantIdCharacterRange(String string, ClientLogger clientLogger) {
        if (string != null) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (ValidationUtil.isValidTenantCharacter(string.charAt(i2))) continue;
                throw clientLogger.logExceptionAsError(new IllegalArgumentException("Invalid tenant id provided. You can locate your tenant id by following the instructions listed here: https://learn.microsoft.com/partner-center/find-ids-and-domain-names"));
            }
        }
    }

    public static void validateInteractiveBrowserRedirectUrlSetup(Integer n2, String string, ClientLogger clientLogger) {
        if (n2 != null && string != null) {
            throw clientLogger.logExceptionAsError(new IllegalArgumentException("Port and Redirect URL cannot be configured at the same time. Port is deprecated now. Use the redirectUrl setter to specify the redirect URL on the builder."));
        }
    }

    private static boolean isValidTenantCharacter(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-';
    }

    public static Path validateSecretFile(File file, ClientLogger clientLogger) {
        Path path = file.toPath();
        if (IdentityUtil.isWindowsPlatform()) {
            String string = System.getenv("ProgramData");
            if (CoreUtils.isNullOrEmpty(string)) {
                throw clientLogger.logExceptionAsError(new ClientAuthenticationException("The ProgramData environment variable is not set.", null));
            }
            String string2 = Paths.get(string, "AzureConnectedMachineAgent", "Tokens").toString();
            if (!path.getParent().toString().equals(string2)) {
                throw clientLogger.logExceptionAsError(new ClientAuthenticationException("The secret key file is not located in the expected directory.", null));
            }
        } else if (IdentityUtil.isLinuxPlatform()) {
            Path path2 = Paths.get("/", "var", "opt", "azcmagent", "tokens");
            if (!path.getParent().equals(path2)) {
                throw clientLogger.logExceptionAsError(new ClientAuthenticationException("The secret key file is not located in the expected directory.", null));
            }
        } else {
            throw clientLogger.logExceptionAsError(new ClientAuthenticationException("The platform is not supported for Azure Arc Managed Identity Endpoint", null));
        }
        if (!path.toString().endsWith(".key")) {
            throw clientLogger.logExceptionAsError(new ClientAuthenticationException("The secret key file does not have the expected file extension", null));
        }
        if (file.length() > 4096L) {
            throw clientLogger.logExceptionAsError(new ClientAuthenticationException("The secret key file is too large to be read from Azure Arc Managed Identity Endpoint", null));
        }
        return path;
    }
}

