/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.models;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class AzureCliToken
implements JsonSerializable<AzureCliToken> {
    private String accessToken;
    private String expiresOn;
    private Long expiresOnUnixTime;
    private String subscription;
    private String tenant;
    private String tokenType;
    private OffsetDateTime tokenExpiry;

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getExpiresOn() {
        return this.expiresOn;
    }

    public Long getExpiresOnUnixTime() {
        return this.expiresOnUnixTime;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public OffsetDateTime getTokenExpiration() {
        return this.tokenExpiry;
    }

    private static OffsetDateTime parseExpiresOnTime(String string) {
        OffsetDateTime offsetDateTime = LocalDateTime.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS")).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
        return offsetDateTime;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expiresOn", this.expiresOn);
        jsonWriter.writeNumberField("expires_on", this.expiresOnUnixTime);
        jsonWriter.writeStringField("subscription", this.subscription);
        jsonWriter.writeStringField("tenant", this.tenant);
        jsonWriter.writeStringField("tokenType", this.tokenType);
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    public static AzureCliToken fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            AzureCliToken azureCliToken = new AzureCliToken();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String string = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("accessToken".equals(string)) {
                    azureCliToken.accessToken = jsonReader.getString();
                    continue;
                }
                if ("expiresOn".equals(string)) {
                    azureCliToken.expiresOn = jsonReader.getString();
                    continue;
                }
                if ("expires_on".equals(string)) {
                    azureCliToken.expiresOnUnixTime = jsonReader.getLong();
                    continue;
                }
                if ("subscription".equals(string)) {
                    azureCliToken.subscription = jsonReader.getString();
                    continue;
                }
                if ("tenant".equals(string)) {
                    azureCliToken.tenant = jsonReader.getString();
                    continue;
                }
                if ("tokenType".equals(string)) {
                    azureCliToken.tokenType = jsonReader.getString();
                    continue;
                }
                jsonReader.skipChildren();
            }
            azureCliToken.tokenExpiry = azureCliToken.expiresOnUnixTime != null ? Instant.ofEpochSecond(azureCliToken.getExpiresOnUnixTime()).atOffset(ZoneOffset.UTC) : AzureCliToken.parseExpiresOnTime(azureCliToken.getExpiresOn());
            return azureCliToken;
        });
    }
}

