/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.IntelliJCryptoUtil;

public class IntelliJKdbxMetadata {
    public static final UUID AES_CIPHER = UUID.fromString("31C1F2E6-BF71-4350-BE58-05216AFC5AFF");
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJKdbxMetadata.class);
    private UUID cipherUuid;
    private DatabaseCompressionFlags databaseCompressionFlags;
    private byte[] baseSeed;
    private byte[] transformSeed;
    private long transformRounds;
    private byte[] encryptionIv;
    private byte[] encryptionKey;
    private DatabaseEncryptionAlgorithm databaseEncryptionAlgorithm;
    private byte[] initBytes;
    private byte[] headerHash;

    public IntelliJKdbxMetadata() {
        SecureRandom secureRandom = new SecureRandom();
        this.cipherUuid = AES_CIPHER;
        this.databaseCompressionFlags = DatabaseCompressionFlags.GZIP;
        this.baseSeed = secureRandom.generateSeed(32);
        this.transformSeed = secureRandom.generateSeed(32);
        this.transformRounds = 6000L;
        this.encryptionIv = secureRandom.generateSeed(16);
        this.encryptionKey = secureRandom.generateSeed(32);
        this.initBytes = new byte[32];
        this.databaseEncryptionAlgorithm = DatabaseEncryptionAlgorithm.SALSA_20;
    }

    public InputStream createDecryptedStream(byte[] byArray, InputStream inputStream) throws IOException {
        byte[] byArray2 = IntelliJCryptoUtil.createKey(byArray, this.getBaseSeed(), this.getTransformSeed(), this.getTransformRounds());
        return IntelliJCryptoUtil.getDecryptedInputStream(inputStream, byArray2, this.getEncryptionIv());
    }

    public DatabaseCompressionFlags getDatabaseCompressionFlags() {
        return this.databaseCompressionFlags;
    }

    public byte[] getBaseSeed() {
        return this.baseSeed;
    }

    public byte[] getTransformSeed() {
        return this.transformSeed;
    }

    public long getTransformRounds() {
        return this.transformRounds;
    }

    public byte[] getEncryptionIv() {
        return this.encryptionIv;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public byte[] getInitBytes() {
        return this.initBytes;
    }

    public void setCipherUuid(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        UUID uUID = new UUID(byteBuffer.getLong(), byteBuffer.getLong(8));
        if (!uUID.equals(AES_CIPHER)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Unknown Cipher UUID " + uUID.toString()));
        }
        this.cipherUuid = uUID;
    }

    public void setDatabaseCompressionFlags(int n2) {
        this.databaseCompressionFlags = DatabaseCompressionFlags.values()[n2];
    }

    public void setBaseSeed(byte[] byArray) {
        this.baseSeed = byArray;
    }

    public void setTransformSeed(byte[] byArray) {
        this.transformSeed = byArray;
    }

    public void setTransformRounds(long l2) {
        this.transformRounds = l2;
    }

    public void setEncryptionIv(byte[] byArray) {
        this.encryptionIv = byArray;
    }

    public void setEncryptionKey(byte[] byArray) {
        this.encryptionKey = byArray;
    }

    public void setInitBytes(byte[] byArray) {
        this.initBytes = byArray;
    }

    public void setEncryptionAlgorithm(int n2) {
        this.databaseEncryptionAlgorithm = DatabaseEncryptionAlgorithm.values()[n2];
    }

    public void setHeaderHash(byte[] byArray) {
        this.headerHash = byArray;
    }

    public static enum DatabaseCompressionFlags {
        NONE,
        GZIP;

    }

    public static enum DatabaseEncryptionAlgorithm {
        NONE,
        ARC_FOUR,
        SALSA_20;

    }
}

