/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.win32.W32APIOptions;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.WindowsCredentialApi;

public class WindowsCredentialAccessor {
    private static final ClientLogger LOGGER = new ClientLogger(WindowsCredentialAccessor.class);
    private WindowsCredentialApi accessor = (WindowsCredentialApi)Native.load((String)"Advapi32", WindowsCredentialApi.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    private String serviceName;
    private String accountName;

    public WindowsCredentialAccessor(String string, String string2) {
        this.serviceName = string;
        this.accountName = string2;
    }

    public String read() {
        WindowsCredentialApi.PCREDENTIAL pCREDENTIAL = new WindowsCredentialApi.PCREDENTIAL();
        try {
            boolean bl2 = this.accessor.CredRead(String.format("%s/%s", this.serviceName, this.accountName), 1, 0, pCREDENTIAL);
            if (!bl2) {
                int n2 = Kernel32.INSTANCE.GetLastError();
                String string = Kernel32Util.formatMessage((int)n2);
                throw LOGGER.logExceptionAsError(new RuntimeException(string));
            }
            WindowsCredentialApi.CREDENTIAL cREDENTIAL = new WindowsCredentialApi.CREDENTIAL(pCREDENTIAL.credential);
            byte[] byArray = cREDENTIAL.CredentialBlob.getByteArray(0L, cREDENTIAL.CredentialBlobSize);
            String string = new String(byArray, StandardCharsets.UTF_8);
            return string;
        }
        catch (LastErrorException lastErrorException) {
            int n3 = lastErrorException.getErrorCode();
            String string = Kernel32Util.formatMessage((int)n3);
            throw LOGGER.logExceptionAsError(new RuntimeException(string));
        }
        finally {
            if (pCREDENTIAL.credential != null) {
                this.accessor.CredFree(pCREDENTIAL.credential);
            }
        }
    }
}

