/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.LinuxKeyRingAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.WindowsCredentialAccessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.json.JsonReadFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;

public class VisualStudioCacheAccessor {
    private static final String PLATFORM_NOT_SUPPORTED_ERROR = "Platform could not be determined for VS Code credential authentication.";
    private static final Pattern REFRESH_TOKEN_PATTERN = Pattern.compile("^[-_.a-zA-Z0-9]+$");
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true).configure(JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature(), true).configure(JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature(), true);

    private JsonNode getUserSettings() {
        JsonNode jsonNode;
        String string = System.getProperty("user.home");
        try {
            String string2;
            if (Platform.isWindows()) {
                string2 = Paths.get(System.getenv("APPDATA"), "Code", "User", "settings.json").toString();
            } else if (Platform.isMac()) {
                string2 = Paths.get(string, "Library", "Application Support", "Code", "User", "settings.json").toString();
            } else if (Platform.isLinux()) {
                string2 = Paths.get(string, ".config", "Code", "User", "settings.json").toString();
            } else {
                throw new CredentialUnavailableException(PLATFORM_NOT_SUPPORTED_ERROR);
            }
            jsonNode = VisualStudioCacheAccessor.readJsonFile(string2);
        }
        catch (Exception exception) {
            return null;
        }
        return jsonNode;
    }

    static JsonNode readJsonFile(String string) throws IOException {
        return MAPPER.readTree(new File(string));
    }

    public Map<String, String> getUserSettingsDetails() {
        JsonNode jsonNode = this.getUserSettings();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        String string2 = "AzureCloud";
        if (jsonNode != null && !jsonNode.isNull()) {
            if (jsonNode.has("azure.tenant")) {
                string = jsonNode.get("azure.tenant").asText();
            }
            if (jsonNode.has("azure.cloud")) {
                string2 = jsonNode.get("azure.cloud").asText();
            }
        }
        if (!CoreUtils.isNullOrEmpty(string)) {
            hashMap.put("tenant", string);
        }
        hashMap.put("cloud", string2);
        return hashMap;
    }

    public String getCredentials(String string, String string2) {
        String string3;
        if (Platform.isWindows()) {
            try {
                string3 = new WindowsCredentialAccessor(string, string2).read();
            }
            catch (Error | Exception throwable) {
                throw new CredentialUnavailableException("Failed to read Vs Code credentials from Windows Credential API.", throwable);
            }
        } else if (Platform.isMac()) {
            try {
                KeyChainAccessor keyChainAccessor = new KeyChainAccessor(null, string, string2);
                byte[] byArray = keyChainAccessor.read();
                string3 = new String(byArray, StandardCharsets.UTF_8);
            }
            catch (Error | Exception throwable) {
                throw new CredentialUnavailableException("Failed to read Vs Code credentials from Mac Native Key Chain.", throwable);
            }
        } else if (Platform.isLinux()) {
            try {
                LinuxKeyRingAccessor linuxKeyRingAccessor = new LinuxKeyRingAccessor("org.freedesktop.Secret.Generic", "service", string, "account", string2);
                byte[] byArray = linuxKeyRingAccessor.read();
                string3 = new String(byArray, StandardCharsets.UTF_8);
            }
            catch (Error | Exception throwable) {
                throw new CredentialUnavailableException("Failed to read Vs Code credentials from Linux Key Ring.", throwable);
            }
        } else {
            throw new CredentialUnavailableException(PLATFORM_NOT_SUPPORTED_ERROR);
        }
        if (CoreUtils.isNullOrEmpty(string3) || !this.isRefreshTokenString(string3)) {
            throw new CredentialUnavailableException("Please authenticate via Azure Tools plugin in VS Code IDE.");
        }
        return string3;
    }

    private boolean isRefreshTokenString(String string) {
        return REFRESH_TOKEN_PATTERN.matcher(string).matches();
    }

    public String getAzureAuthHost(String string) {
        switch (string) {
            case "AzureCloud": {
                return "https://login.microsoftonline.com/";
            }
            case "AzureChina": {
                return "https://login.chinacloudapi.cn/";
            }
            case "AzureGermanCloud": {
                return "https://login.microsoftonline.de/";
            }
            case "AzureUSGovernment": {
                return "https://login.microsoftonline.us/";
            }
        }
        return "https://login.microsoftonline.com/";
    }
}

