/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.time.Duration;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class SynchronousAccessor<T> {
    private volatile T cache;
    private Supplier<T> cacheSupplier;
    private ReentrantLock lock;
    private Duration cacheTimeout;
    private long startTimeInMillis;

    public SynchronousAccessor(Supplier<T> supplier) {
        this.cacheSupplier = supplier;
        this.startTimeInMillis = System.currentTimeMillis();
        this.lock = new ReentrantLock();
    }

    public SynchronousAccessor(Supplier<T> supplier, Duration duration) {
        this.cacheSupplier = supplier;
        this.startTimeInMillis = System.currentTimeMillis();
        this.cacheTimeout = duration;
        this.lock = new ReentrantLock();
    }

    public T getValue() {
        if (this.cache == null || this.shouldRefreshCache()) {
            this.lock.lock();
            try {
                this.cache = this.cacheSupplier.get();
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.cache;
    }

    private boolean shouldRefreshCache() {
        return this.cacheTimeout != null ? System.currentTimeMillis() - this.startTimeInMillis >= this.cacheTimeout.toMillis() : false;
    }
}

