/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.sun.jna.Platform;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class PowershellManager {
    private static final ClientLogger LOGGER = new ClientLogger(PowershellManager.class);
    public static final Pattern PS_RESPONSE_PATTERN = Pattern.compile("\\s+$");
    private Process process;
    private PrintWriter commandWriter;
    private boolean closed;
    private int waitPause = 1000;
    private long maxWait = 10000L;
    private final String powershellPath;
    private ExecutorService executorService;

    public PowershellManager(String string) {
        this.powershellPath = string;
    }

    public PowershellManager(String string, ExecutorService executorService) {
        this.powershellPath = string;
        this.executorService = executorService;
    }

    public Mono<PowershellManager> initSession() {
        ProcessBuilder processBuilder = Platform.isWindows() ? new ProcessBuilder("cmd.exe", "/c", "chcp", "65001", ">", "NUL", "&", this.powershellPath, "-ExecutionPolicy", "Bypass", "-NoExit", "-NoProfile", "-Command", "-") : new ProcessBuilder(this.powershellPath, "-nologo", "-noexit", "-Command", "-");
        processBuilder.redirectErrorStream(true);
        Supplier<PowershellManager> supplier = () -> {
            try {
                this.process = processBuilder.start();
                this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.process.getOutputStream()), StandardCharsets.UTF_8), true);
                if (this.process.waitFor(4L, TimeUnit.SECONDS) && !this.process.isAlive()) {
                    throw new CredentialUnavailableException("Unable to execute PowerShell. Please make sure that it is installed in your system.");
                }
                this.closed = false;
            }
            catch (IOException | InterruptedException exception) {
                throw new CredentialUnavailableException("Unable to execute PowerShell. Please make sure that it is installed in your system", (Throwable)exception);
            }
            return this;
        };
        return this.executorService != null ? Mono.fromFuture(CompletableFuture.supplyAsync(supplier, this.executorService)) : Mono.fromFuture(CompletableFuture.supplyAsync(supplier));
    }

    public Mono<String> runCommand(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder stringBuilder = new StringBuilder();
        this.commandWriter.println(string);
        return this.canRead(bufferedReader).flatMap(bl3 -> {
            if (bl3.booleanValue()) {
                return this.readData(bufferedReader, stringBuilder).flatMap(bl2 -> Mono.just((Object)PS_RESPONSE_PATTERN.matcher(stringBuilder.toString()).replaceAll("")));
            }
            return Mono.error((Throwable)new CredentialUnavailableException("Error reading data from reader"));
        });
    }

    private Mono<Boolean> readData(BufferedReader bufferedReader, StringBuilder stringBuilder) {
        return Mono.defer(() -> {
            try {
                String string = bufferedReader.readLine();
                if (string != null) {
                    stringBuilder.append(string).append("\r\n");
                    return this.canRead(bufferedReader).flatMap(bl2 -> {
                        if (!this.closed && bl2.booleanValue()) {
                            return Mono.empty();
                        }
                        return Mono.just((Object)true);
                    });
                }
                return Mono.just((Object)true);
            }
            catch (IOException iOException) {
                return Mono.error((Throwable)new CredentialUnavailableException("Powershell reader not ready for reading", (Throwable)iOException));
            }
        }).repeatWhenEmpty(flux -> flux.concatMap(l2 -> Flux.just((Object)true)));
    }

    private Mono<Boolean> canRead(BufferedReader bufferedReader) {
        Supplier<Boolean> supplier = () -> {
            int n2 = 62;
            int n3 = Platform.isMac() ? this.waitPause : 500;
            try {
                while (!bufferedReader.ready()) {
                    if (n2 > n3) {
                        return false;
                    }
                    Thread.sleep(n2 *= 2);
                }
            }
            catch (IOException | InterruptedException exception) {
                throw new CredentialUnavailableException("Powershell reader not ready for reading", (Throwable)exception);
            }
            return true;
        };
        return this.executorService != null ? Mono.fromFuture(CompletableFuture.supplyAsync(supplier, this.executorService)) : Mono.fromFuture(CompletableFuture.supplyAsync(supplier));
    }

    public Mono<Boolean> close() {
        if (!this.closed && this.process != null) {
            Supplier<Boolean> supplier = () -> {
                this.commandWriter.println("exit");
                try {
                    this.process.waitFor(this.maxWait, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.logExceptionAsError(new RuntimeException("PowerShell process encountered unexpected error when closing.", interruptedException));
                }
                finally {
                    this.commandWriter.close();
                    try {
                        if (this.process.isAlive()) {
                            this.process.getInputStream().close();
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.logExceptionAsError(new RuntimeException("PowerShell stream encountered unexpected error when closing.", iOException));
                    }
                    this.closed = true;
                }
                return this.closed;
            };
            return this.executorService != null ? Mono.fromFuture(CompletableFuture.supplyAsync(supplier, this.executorService)) : Mono.fromFuture(CompletableFuture.supplyAsync(supplier));
        }
        return Mono.just((Object)true);
    }
}

