/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.ProxyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRecord;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.BrowserCustomizationOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityLogOptionsImpl;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.ManagedIdentityType;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.RegionalAuthority;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserAssertion;

public final class IdentityClientOptions
implements Cloneable {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityClientOptions.class);
    private static final int MAX_RETRY_DEFAULT_LIMIT = 6;
    public static final String AZURE_IDENTITY_DISABLE_MULTI_TENANT_AUTH = "AZURE_IDENTITY_DISABLE_MULTITENANTAUTH";
    public static final String AZURE_POD_IDENTITY_AUTHORITY_HOST = "AZURE_POD_IDENTITY_AUTHORITY_HOST";
    private String authorityHost;
    private BrowserCustomizationOptions browserCustomizationOptions;
    private String imdsAuthorityHost;
    private int maxRetry;
    private Function<Duration, Duration> retryTimeout;
    private ProxyOptions proxyOptions;
    private HttpPipeline httpPipeline;
    private ExecutorService executorService;
    private HttpClient httpClient;
    private boolean allowUnencryptedCache;
    private boolean sharedTokenCacheEnabled;
    private String keePassDatabasePath;
    private boolean includeX5c;
    private AuthenticationRecord authenticationRecord;
    private TokenCachePersistenceOptions tokenCachePersistenceOptions;
    private RegionalAuthority regionalAuthority;
    private UserAssertion userAssertion;
    private boolean multiTenantAuthDisabled;
    private Configuration configuration;
    private IdentityLogOptionsImpl identityLogOptionsImpl;
    private boolean accountIdentifierLogging;
    private ManagedIdentityType managedIdentityType;
    private ManagedIdentityParameters managedIdentityParameters;
    private Set<String> additionallyAllowedTenants;
    private ClientOptions clientOptions;
    private HttpLogOptions httpLogOptions;
    private RetryOptions retryOptions;
    private RetryPolicy retryPolicy;
    private List<HttpPipelinePolicy> perCallPolicies;
    private List<HttpPipelinePolicy> perRetryPolicies;
    private boolean instanceDiscovery;
    private Duration credentialProcessTimeout = Duration.ofSeconds(10L);
    private boolean isChained;
    private boolean enableUnsafeSupportLogging;
    private long brokerWindowHandle;
    private boolean brokerEnabled;
    private boolean enableMsaPassthrough;
    private boolean useDefaultBrokerAccount;

    public IdentityClientOptions() {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.loadFromConfiguration(configuration);
        this.identityLogOptionsImpl = new IdentityLogOptionsImpl();
        this.browserCustomizationOptions = new BrowserCustomizationOptions();
        this.maxRetry = 6;
        this.retryTimeout = IdentityClientOptions.getIMDSretryTimeoutFunction();
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
        this.additionallyAllowedTenants = new HashSet<String>();
        this.regionalAuthority = RegionalAuthority.fromString(configuration.get("AZURE_REGIONAL_AUTHORITY_NAME"));
        this.instanceDiscovery = true;
    }

    private static Function<Duration, Duration> getIMDSretryTimeoutFunction() {
        return duration -> {
            long l2 = duration.getSeconds();
            long l3 = (long)(800.0 * Math.pow(2.0, l2 - 1L));
            return Duration.ofMillis(l3);
        };
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public IdentityClientOptions setAuthorityHost(String string) {
        this.authorityHost = string;
        return this;
    }

    public String getImdsAuthorityHost() {
        return this.imdsAuthorityHost;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public IdentityClientOptions setMaxRetry(int n2) {
        this.maxRetry = n2;
        return this;
    }

    public Function<Duration, Duration> getRetryTimeout() {
        return this.retryTimeout;
    }

    public IdentityClientOptions setRetryTimeout(Function<Duration, Duration> function) {
        this.retryTimeout = function;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public IdentityClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public IdentityClientOptions setHttpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public IdentityClientOptions setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public IdentityClientOptions setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public IdentityClientOptions setAllowUnencryptedCache(boolean bl2) {
        this.allowUnencryptedCache = bl2;
        return this;
    }

    public boolean getAllowUnencryptedCache() {
        return this.allowUnencryptedCache;
    }

    public IdentityClientOptions setIntelliJKeePassDatabasePath(String string) {
        this.keePassDatabasePath = string;
        return this;
    }

    public boolean isSharedTokenCacheEnabled() {
        return this.sharedTokenCacheEnabled;
    }

    public IdentityClientOptions enablePersistentCache() {
        this.sharedTokenCacheEnabled = true;
        return this;
    }

    public String getIntelliJKeePassDatabasePath() {
        return this.keePassDatabasePath;
    }

    public IdentityClientOptions setAuthenticationRecord(AuthenticationRecord authenticationRecord) {
        this.authenticationRecord = authenticationRecord;
        return this;
    }

    public boolean isIncludeX5c() {
        return this.includeX5c;
    }

    public IdentityClientOptions setIncludeX5c(boolean bl2) {
        this.includeX5c = bl2;
        return this;
    }

    public AuthenticationRecord getAuthenticationRecord() {
        return this.authenticationRecord;
    }

    public IdentityClientOptions setTokenCacheOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.tokenCachePersistenceOptions = tokenCachePersistenceOptions;
        return this;
    }

    public TokenCachePersistenceOptions getTokenCacheOptions() {
        return this.tokenCachePersistenceOptions;
    }

    public RegionalAuthority getRegionalAuthority() {
        return this.regionalAuthority;
    }

    public IdentityClientOptions userAssertion(String string) {
        this.userAssertion = new UserAssertion(string);
        return this;
    }

    public UserAssertion getUserAssertion() {
        return this.userAssertion;
    }

    public boolean isMultiTenantAuthenticationDisabled() {
        return this.multiTenantAuthDisabled;
    }

    public IdentityClientOptions disableMultiTenantAuthentication() {
        this.multiTenantAuthDisabled = true;
        return this;
    }

    public IdentityClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.loadFromConfiguration(configuration);
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public IdentityLogOptionsImpl getIdentityLogOptionsImpl() {
        return this.identityLogOptionsImpl;
    }

    public IdentityClientOptions setIdentityLogOptionsImpl(IdentityLogOptionsImpl identityLogOptionsImpl) {
        this.identityLogOptionsImpl = identityLogOptionsImpl;
        return this;
    }

    public IdentityClientOptions setManagedIdentityType(ManagedIdentityType managedIdentityType) {
        this.managedIdentityType = managedIdentityType;
        return this;
    }

    public ManagedIdentityType getManagedIdentityType() {
        return this.managedIdentityType;
    }

    public ManagedIdentityParameters getManagedIdentityParameters() {
        return this.managedIdentityParameters;
    }

    public IdentityClientOptions setManagedIdentityParameters(ManagedIdentityParameters managedIdentityParameters) {
        this.managedIdentityParameters = managedIdentityParameters;
        return this;
    }

    public IdentityClientOptions setAdditionallyAllowedTenants(List<String> list) {
        this.additionallyAllowedTenants = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.additionallyAllowedTenants.addAll(list);
        return this;
    }

    public Set<String> getAdditionallyAllowedTenants() {
        return this.additionallyAllowedTenants;
    }

    public IdentityClientOptions setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public IdentityClientOptions setHttpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public HttpLogOptions getHttpLogOptions() {
        return this.httpLogOptions;
    }

    public IdentityClientOptions setRetryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public IdentityClientOptions setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public IdentityClientOptions addPerCallPolicy(HttpPipelinePolicy httpPipelinePolicy) {
        this.perCallPolicies.add(httpPipelinePolicy);
        return this;
    }

    public IdentityClientOptions addPerRetryPolicy(HttpPipelinePolicy httpPipelinePolicy) {
        this.perRetryPolicies.add(httpPipelinePolicy);
        return this;
    }

    public List<HttpPipelinePolicy> getPerRetryPolicies() {
        return this.perRetryPolicies;
    }

    public List<HttpPipelinePolicy> getPerCallPolicies() {
        return this.perCallPolicies;
    }

    IdentityClientOptions setMultiTenantAuthDisabled(boolean bl2) {
        this.multiTenantAuthDisabled = bl2;
        return this;
    }

    IdentityClientOptions setAdditionallyAllowedTenants(Set<String> set) {
        this.additionallyAllowedTenants = set;
        return this;
    }

    IdentityClientOptions setRegionalAuthority(RegionalAuthority regionalAuthority) {
        this.regionalAuthority = regionalAuthority;
        return this;
    }

    IdentityClientOptions setConfigurationStore(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    IdentityClientOptions setUserAssertion(UserAssertion userAssertion) {
        this.userAssertion = userAssertion;
        return this;
    }

    IdentityClientOptions setPersistenceCache(boolean bl2) {
        this.sharedTokenCacheEnabled = bl2;
        return this;
    }

    IdentityClientOptions setImdsAuthorityHost(String string) {
        this.imdsAuthorityHost = string;
        return this;
    }

    IdentityClientOptions setPerCallPolicies(List<HttpPipelinePolicy> list) {
        this.perCallPolicies = list;
        return this;
    }

    IdentityClientOptions setPerRetryPolicies(List<HttpPipelinePolicy> list) {
        this.perRetryPolicies = list;
        return this;
    }

    public IdentityClientOptions disableInstanceDiscovery() {
        this.instanceDiscovery = false;
        return this;
    }

    public IdentityClientOptions setBrowserCustomizationOptions(BrowserCustomizationOptions browserCustomizationOptions) {
        this.browserCustomizationOptions = browserCustomizationOptions;
        return this;
    }

    public BrowserCustomizationOptions getBrowserCustomizationOptions() {
        return this.browserCustomizationOptions;
    }

    public boolean isInstanceDiscoveryEnabled() {
        return this.instanceDiscovery;
    }

    private void loadFromConfiguration(Configuration configuration) {
        this.authorityHost = configuration.get("AZURE_AUTHORITY_HOST", "https://login.microsoftonline.com/");
        this.imdsAuthorityHost = configuration.get(AZURE_POD_IDENTITY_AUTHORITY_HOST, "http://169.254.169.254");
        ValidationUtil.validateAuthHost(this.authorityHost, LOGGER);
        this.multiTenantAuthDisabled = configuration.get(AZURE_IDENTITY_DISABLE_MULTI_TENANT_AUTH, false);
    }

    public Duration getCredentialProcessTimeout() {
        return this.credentialProcessTimeout;
    }

    public void setCredentialProcessTimeout(Duration duration) {
        this.credentialProcessTimeout = duration;
    }

    public boolean isChained() {
        return this.isChained;
    }

    public IdentityClientOptions setChained(boolean bl2) {
        this.isChained = bl2;
        return this;
    }

    public boolean isUnsafeSupportLoggingEnabled() {
        return this.enableUnsafeSupportLogging;
    }

    public IdentityClientOptions enableUnsafeSupportLogging() {
        this.enableUnsafeSupportLogging = true;
        return this;
    }

    public IdentityClientOptions setBrokerWindowHandle(long l2) {
        this.brokerEnabled = true;
        this.brokerWindowHandle = l2;
        return this;
    }

    public long getBrokerWindowHandle() {
        return this.brokerWindowHandle;
    }

    public boolean isBrokerEnabled() {
        return this.brokerEnabled;
    }

    public IdentityClientOptions setEnableLegacyMsaPassthrough(boolean bl2) {
        this.brokerEnabled = true;
        this.enableMsaPassthrough = bl2;
        return this;
    }

    public IdentityClientOptions setUseDefaultBrokerAccount(boolean bl2) {
        this.useDefaultBrokerAccount = bl2;
        return this;
    }

    public boolean isMsaPassthroughEnabled() {
        return this.enableMsaPassthrough;
    }

    public boolean useDefaultBrokerAccount() {
        return this.useDefaultBrokerAccount;
    }

    public IdentityClientOptions clone() {
        IdentityClientOptions identityClientOptions = new IdentityClientOptions().setAdditionallyAllowedTenants(this.additionallyAllowedTenants).setAllowUnencryptedCache(this.allowUnencryptedCache).setHttpClient(this.httpClient).setAuthenticationRecord(this.authenticationRecord).setExecutorService(this.executorService).setIdentityLogOptionsImpl(this.identityLogOptionsImpl).setTokenCacheOptions(this.tokenCachePersistenceOptions).setRetryTimeout(this.retryTimeout).setRegionalAuthority(this.regionalAuthority).setHttpPipeline(this.httpPipeline).setIncludeX5c(this.includeX5c).setProxyOptions(this.proxyOptions).setMaxRetry(this.maxRetry).setIntelliJKeePassDatabasePath(this.keePassDatabasePath).setAuthorityHost(this.authorityHost).setImdsAuthorityHost(this.imdsAuthorityHost).setMultiTenantAuthDisabled(this.multiTenantAuthDisabled).setUserAssertion(this.userAssertion).setConfigurationStore(this.configuration).setPersistenceCache(this.sharedTokenCacheEnabled).setClientOptions(this.clientOptions).setHttpLogOptions(this.httpLogOptions).setRetryOptions(this.retryOptions).setRetryPolicy(this.retryPolicy).setPerCallPolicies(this.perCallPolicies).setPerRetryPolicies(this.perRetryPolicies).setBrowserCustomizationOptions(this.browserCustomizationOptions).setChained(this.isChained);
        if (this.isBrokerEnabled()) {
            identityClientOptions.setBrokerWindowHandle(this.brokerWindowHandle);
            identityClientOptions.setEnableLegacyMsaPassthrough(this.enableMsaPassthrough);
        }
        if (!this.isInstanceDiscoveryEnabled()) {
            identityClientOptions.disableInstanceDiscovery();
        }
        if (this.isUnsafeSupportLoggingEnabled()) {
            identityClientOptions.enableUnsafeSupportLogging();
        }
        return identityClientOptions;
    }
}

