/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.ProxyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.DeviceCodeInfo;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.CustomClaimRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IntelliJAuthMethodDetails;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IntelliJCacheAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MSIToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.ManagedIdentityType;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.PowershellManager;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.SynchronizedAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.VisualStudioCacheAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentitySslUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ScopeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppTokenProviderParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenProviderResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class IdentityClient
extends IdentityClientBase {
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessor = new SynchronizedAccessor(() -> this.getPublicClientApplication(bl2, false));
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessorWithCae = new SynchronizedAccessor(() -> this.getPublicClientApplication(bl2, true));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor = new SynchronizedAccessor(() -> this.getConfidentialClientApplication(false));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessorWithCae = new SynchronizedAccessor(() -> this.getConfidentialClientApplication(true));
    private final SynchronizedAccessor<ConfidentialClientApplication> managedIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getManagedIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<ConfidentialClientApplication> workloadIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getWorkloadIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<String> clientAssertionAccessor;

    IdentityClient(String string, String string2, String string3, String string4, String string5, String string6, Supplier<String> supplier, byte[] byArray, String string7, boolean bl2, Duration duration, IdentityClientOptions identityClientOptions) {
        super(string, string2, string3, string4, string5, string6, supplier, byArray, string7, bl2, duration, identityClientOptions);
        Duration duration2 = duration == null ? Duration.ofMinutes(5L) : duration;
        this.clientAssertionAccessor = new SynchronizedAccessor(this::parseClientAssertion, duration2);
    }

    private Mono<ConfidentialClientApplication> getConfidentialClientApplication(boolean bl2) {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)this.getConfidentialClient(bl2));
            }
            catch (RuntimeException runtimeException) {
                return Mono.error((Throwable)runtimeException);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getManagedIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)super.getManagedIdentityConfidentialClient());
            }
            catch (RuntimeException runtimeException) {
                return Mono.error((Throwable)runtimeException);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getWorkloadIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)super.getWorkloadIdentityConfidentialClient());
            }
            catch (RuntimeException runtimeException) {
                return Mono.error((Throwable)runtimeException);
            }
        });
    }

    @Override
    Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext tokenRequestContext) {
        ManagedIdentityParameters managedIdentityParameters = this.options.getManagedIdentityParameters();
        ManagedIdentityType managedIdentityType = this.options.getManagedIdentityType();
        switch (managedIdentityType) {
            case APP_SERVICE: {
                return this.authenticateToManagedIdentityEndpoint(managedIdentityParameters.getIdentityEndpoint(), managedIdentityParameters.getIdentityHeader(), managedIdentityParameters.getMsiEndpoint(), managedIdentityParameters.getMsiSecret(), tokenRequestContext);
            }
            case SERVICE_FABRIC: {
                return this.authenticateToServiceFabricManagedIdentityEndpoint(managedIdentityParameters.getIdentityEndpoint(), managedIdentityParameters.getIdentityHeader(), managedIdentityParameters.getIdentityServerThumbprint(), tokenRequestContext);
            }
            case ARC: {
                return this.authenticateToArcManagedIdentityEndpoint(managedIdentityParameters.getIdentityEndpoint(), tokenRequestContext);
            }
            case AKS: {
                return this.authenticateWithExchangeToken(tokenRequestContext);
            }
            case VM: {
                return this.authenticateToIMDSEndpoint(tokenRequestContext);
            }
        }
        return Mono.error((Throwable)LOGGER.logExceptionAsError(new CredentialUnavailableException("Unknown Managed Identity type, authentication not available.")));
    }

    private Mono<String> parseClientAssertion() {
        return Mono.fromCallable(() -> {
            if (this.clientAssertionFilePath != null) {
                byte[] byArray = Files.readAllBytes(Paths.get(this.clientAssertionFilePath, new String[0]));
                return new String(byArray, StandardCharsets.UTF_8);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Client Assertion File Path is not provided. It should be provided to authenticate with client assertion."));
        });
    }

    private Mono<PublicClientApplication> getPublicClientApplication(boolean bl2, boolean bl3) {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)this.getPublicClient(bl2, bl3));
            }
            catch (RuntimeException runtimeException) {
                return Mono.error((Throwable)runtimeException);
            }
        });
    }

    public Mono<MsalToken> authenticateWithIntelliJ(TokenRequestContext tokenRequestContext) {
        try {
            IntelliJAuthMethodDetails intelliJAuthMethodDetails;
            IntelliJCacheAccessor intelliJCacheAccessor = new IntelliJCacheAccessor(this.options.getIntelliJKeePassDatabasePath());
            String string = intelliJCacheAccessor.getIntelliJCredentialsFromIdentityMsalCache();
            if (!CoreUtils.isNullOrEmpty(string)) {
                RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()), string);
                if (tokenRequestContext.getClaims() != null) {
                    ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
                    refreshTokenParametersBuilder.claims(claimsRequest);
                }
                return this.publicClientApplicationAccessor.getValue().flatMap(publicClientApplication -> Mono.fromFuture(publicClientApplication.acquireToken(refreshTokenParametersBuilder.build())).map(MsalToken::new));
            }
            try {
                intelliJAuthMethodDetails = intelliJCacheAccessor.getAuthDetailsIfAvailable();
            }
            catch (CredentialUnavailableException credentialUnavailableException) {
                return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJ Authentication not available.", (Throwable)credentialUnavailableException)));
            }
            if (intelliJAuthMethodDetails == null) {
                return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJ Authentication not available. Please log in with Azure Tools for IntelliJ plugin in the IDE. Fore more details refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/intellijcredential/troubleshoot")));
            }
            String string2 = intelliJAuthMethodDetails.getAuthMethod();
            if ("SP".equalsIgnoreCase(string2)) {
                Map<String, String> map = intelliJCacheAccessor.getIntellijServicePrincipalDetails(intelliJAuthMethodDetails.getCredFilePath());
                String string3 = map.get("authURL") + map.get("tenant");
                try {
                    ConfidentialClientApplication.Builder builder = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder(map.get("client"), ClientCredentialFactory.createFromSecret(map.get("key"))).authority(string3)).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
                    if (this.httpPipelineAdapter != null) {
                        builder.httpClient(this.httpPipelineAdapter);
                    } else if (this.options.getProxyOptions() != null) {
                        builder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
                    }
                    if (this.options.getExecutorService() != null) {
                        builder.executorService(this.options.getExecutorService());
                    }
                    ConfidentialClientApplication confidentialClientApplication = builder.build();
                    return Mono.fromFuture(confidentialClientApplication.acquireToken(ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).build())).map(MsalToken::new);
                }
                catch (MalformedURLException malformedURLException) {
                    return Mono.error((Throwable)malformedURLException);
                }
            }
            if ("DC".equalsIgnoreCase(string2)) {
                LOGGER.verbose("IntelliJ Authentication => Device Code Authentication scheme detected in Azure Tools for IntelliJ Plugin.");
                if (this.isADFSTenant()) {
                    LOGGER.verbose("IntelliJ Authentication => The input tenant is detected to be ADFS and the ADFS tenants are not supported via IntelliJ Authentication currently.");
                    return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJCredential  authentication unavailable. ADFS tenant/authorities are not supported.")));
                }
                try {
                    JsonNode jsonNode = intelliJCacheAccessor.getDeviceCodeCredentials();
                    String string4 = jsonNode.get("refreshToken").textValue();
                    RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()), string4);
                    if (tokenRequestContext.getClaims() != null) {
                        ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
                        refreshTokenParametersBuilder.claims(claimsRequest);
                    }
                    return this.publicClientApplicationAccessor.getValue().flatMap(publicClientApplication -> Mono.fromFuture(publicClientApplication.acquireToken(refreshTokenParametersBuilder.build())).map(MsalToken::new));
                }
                catch (CredentialUnavailableException credentialUnavailableException) {
                    return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, credentialUnavailableException));
                }
            }
            LOGGER.verbose("IntelliJ Authentication = > Only Service Principal and Device Code Authentication schemes are currently supported via IntelliJ Credential currently. Please ensure you used one of those schemes from Azure Tools for IntelliJ plugin.");
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJ Authentication not available. Please login with Azure Tools for IntelliJ plugin in the IDE.")));
        }
        catch (IOException iOException) {
            return Mono.error((Throwable)iOException);
        }
    }

    public Mono<AccessToken> authenticateWithAzureCli(TokenRequestContext tokenRequestContext) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("az account get-access-token --output json --resource ");
        String string = ScopeUtil.scopesToResource(tokenRequestContext.getScopes());
        try {
            ScopeUtil.validateScope(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError(illegalArgumentException));
        }
        stringBuilder.append(string);
        try {
            object = IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options);
            ValidationUtil.validateTenantIdCharacterRange((String)object, LOGGER);
            if (!CoreUtils.isNullOrEmpty((CharSequence)object) && !((String)object).equals("organizations")) {
                stringBuilder.append(" --tenant ").append((String)object);
            }
        }
        catch (IllegalArgumentException | ClientAuthenticationException runtimeException) {
            return Mono.error((Throwable)runtimeException);
        }
        try {
            object = this.getTokenFromAzureCLIAuthentication(stringBuilder);
            return Mono.just((Object)object);
        }
        catch (RuntimeException runtimeException) {
            return Mono.error((Throwable)(runtimeException instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)runtimeException) : LOGGER.logExceptionAsError(runtimeException)));
        }
    }

    public Mono<AccessToken> authenticateWithAzureDeveloperCli(TokenRequestContext tokenRequestContext) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("azd auth token --output json --scope ");
        List<String> list = tokenRequestContext.getScopes();
        if (list.size() == 0) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError(new IllegalArgumentException("Missing scope in request")));
        }
        for (String string : list) {
            try {
                ScopeUtil.validateScope(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError(illegalArgumentException));
            }
        }
        stringBuilder.append(String.join((CharSequence)" --scope ", list));
        try {
            object = IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options);
            ValidationUtil.validateTenantIdCharacterRange((String)object, LOGGER);
            if (!CoreUtils.isNullOrEmpty((CharSequence)object) && !((String)object).equals("organizations")) {
                stringBuilder.append(" --tenant-id ").append((String)object);
            }
        }
        catch (IllegalArgumentException | ClientAuthenticationException runtimeException) {
            return Mono.error((Throwable)runtimeException);
        }
        try {
            object = this.getTokenFromAzureDeveloperCLIAuthentication(stringBuilder);
            return Mono.just((Object)object);
        }
        catch (RuntimeException runtimeException) {
            return Mono.error((Throwable)(runtimeException instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)runtimeException) : LOGGER.logExceptionAsError(runtimeException)));
        }
    }

    public Mono<AccessToken> authenticateWithAzurePowerShell(TokenRequestContext tokenRequestContext) {
        ValidationUtil.validateTenantIdCharacterRange(this.tenantId, LOGGER);
        ArrayList arrayList = new ArrayList(2);
        PowershellManager powershellManager2 = new PowershellManager(Platform.isWindows() ? "pwsh.exe" : "pwsh");
        PowershellManager powershellManager3 = Platform.isWindows() ? new PowershellManager("powershell.exe") : null;
        ArrayList<PowershellManager> arrayList2 = new ArrayList<PowershellManager>(2);
        arrayList2.add(powershellManager2);
        if (powershellManager3 != null) {
            arrayList2.add(powershellManager3);
        }
        return Flux.fromIterable(arrayList2).flatMap(powershellManager -> this.getAccessTokenFromPowerShell(tokenRequestContext, (PowershellManager)powershellManager).onErrorResume(throwable -> {
            if (!throwable.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error((Throwable)new ClientAuthenticationException("Azure Powershell authentication failed. Error Details: " + throwable.getMessage() + ". To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/powershellcredential/troubleshoot", null, (Throwable)throwable));
            }
            arrayList.add((CredentialUnavailableException)throwable);
            return Mono.empty();
        }), 1).next().switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException credentialUnavailableException = (CredentialUnavailableException)arrayList.get(arrayList.size() - 1);
            for (int i2 = arrayList.size() - 2; i2 >= 0; --i2) {
                CredentialUnavailableException credentialUnavailableException2 = (CredentialUnavailableException)arrayList.get(i2);
                credentialUnavailableException = new CredentialUnavailableException("Azure PowerShell authentication failed using defaultpowershell(pwsh) with following error: " + credentialUnavailableException2.getMessage() + "\r\nAzure PowerShell authentication failed using powershell-core(powershell) with following error: " + credentialUnavailableException.getMessage(), credentialUnavailableException.getCause());
            }
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, credentialUnavailableException));
        }));
    }

    public Mono<AccessToken> authenticateWithOBO(TokenRequestContext tokenRequestContext) {
        return this.getConfidentialClientInstance(tokenRequestContext).getValue().flatMap(confidentialClientApplication -> Mono.fromFuture(() -> confidentialClientApplication.acquireToken(this.buildOBOFlowParameters(tokenRequestContext))).map(MsalToken::new));
    }

    private Mono<AccessToken> getAccessTokenFromPowerShell(TokenRequestContext tokenRequestContext, PowershellManager powershellManager) {
        String string = ScopeUtil.scopesToResource(tokenRequestContext.getScopes());
        try {
            ScopeUtil.validateScope(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LOGGER.logExceptionAsError(illegalArgumentException);
        }
        return Mono.using(() -> powershellManager, powershellManager2 -> powershellManager2.initSession().flatMap(powershellManager -> {
            String string2 = "Import-Module Az.Accounts -MinimumVersion 2.2.0 -PassThru";
            return powershellManager.runCommand(string2).flatMap(string3 -> {
                if (string3.contains("The specified module 'Az.Accounts' with version '2.2.0' was not loaded because no valid module file")) {
                    return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Az.Account module with version >= 2.2.0 is not installed. It needs to be installed to use Azure PowerShell Credential.")));
                }
                LOGGER.verbose("Az.accounts module was found installed.");
                String string4 = "Get-AzAccessToken -ResourceUrl '" + string + "' | ConvertTo-Json";
                LOGGER.verbose("Azure Powershell Authentication => Executing the command `{}` in Azure Powershell to retrieve the Access Token.", string4);
                return powershellManager.runCommand(string4).flatMap(string -> {
                    if (string.contains("Run Connect-AzAccount to login")) {
                        return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Run Connect-AzAccount to login to Azure account in PowerShell.")));
                    }
                    try {
                        LOGGER.verbose("Azure Powershell Authentication => Attempting to deserialize the received response from Azure Powershell.");
                        Map map = (Map)SERIALIZER_ADAPTER.deserialize((String)string, (Type)((Object)Map.class), SerializerEncoding.JSON);
                        String string2 = (String)map.get("Token");
                        String string3 = (String)map.get("ExpiresOn");
                        OffsetDateTime offsetDateTime = OffsetDateTime.parse(string3).withOffsetSameInstant(ZoneOffset.UTC);
                        return Mono.just((Object)new AccessToken(string2, offsetDateTime));
                    }
                    catch (IOException iOException) {
                        return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Encountered error when deserializing response from Azure Power Shell.", (Throwable)iOException)));
                    }
                });
            });
        }), PowershellManager::close);
    }

    public Mono<AccessToken> authenticateWithConfidentialClient(TokenRequestContext tokenRequestContext) {
        return this.getConfidentialClientInstance(tokenRequestContext).getValue().flatMap(confidentialClientApplication -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = this.buildConfidentialClientParameters(tokenRequestContext);
            return confidentialClientApplication.acquireToken(clientCredentialParametersBuilder.build());
        })).map(MsalToken::new);
    }

    private SynchronizedAccessor<ConfidentialClientApplication> getConfidentialClientInstance(TokenRequestContext tokenRequestContext) {
        return tokenRequestContext.isCaeEnabled() ? this.confidentialClientApplicationAccessorWithCae : this.confidentialClientApplicationAccessor;
    }

    private ClientCredentialParameters.ClientCredentialParametersBuilder buildConfidentialClientParameters(TokenRequestContext tokenRequestContext) {
        ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (this.clientAssertionSupplier != null) {
            clientCredentialParametersBuilder.clientCredential(ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplier.get()));
        }
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            clientCredentialParametersBuilder.claims(claimsRequest);
        }
        return clientCredentialParametersBuilder;
    }

    public Mono<AccessToken> authenticateWithManagedIdentityConfidentialClient(TokenRequestContext tokenRequestContext) {
        return this.managedIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClientApplication -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
            return confidentialClientApplication.acquireToken(clientCredentialParametersBuilder.build());
        })).onErrorMap(throwable -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)throwable)).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithWorkloadIdentityConfidentialClient(TokenRequestContext tokenRequestContext) {
        return this.workloadIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClientApplication -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
            return confidentialClientApplication.acquireToken(clientCredentialParametersBuilder.build());
        })).onErrorMap(throwable -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)throwable)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(TokenRequestContext tokenRequestContext, String string, String string2) {
        return this.getPublicClientInstance(tokenRequestContext).getValue().flatMap(publicClientApplication -> Mono.fromFuture(() -> {
            UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = this.buildUsernamePasswordFlowParameters(tokenRequestContext, string, string2);
            return publicClientApplication.acquireToken(userNamePasswordParametersBuilder.build());
        })).onErrorMap(throwable -> new ClientAuthenticationException("Failed to acquire token with username and password. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/usernamepasswordcredential/troubleshoot", null, (Throwable)throwable)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithPublicClientCache(TokenRequestContext tokenRequestContext, IAccount iAccount) {
        return this.getPublicClientInstance(tokenRequestContext).getValue().flatMap(publicClientApplication -> Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(tokenRequestContext, (PublicClientApplication)publicClientApplication, iAccount, false)).map(MsalToken::new).filter(msalToken -> OffsetDateTime.now().isBefore(msalToken.getExpiresAt().minus(REFRESH_OFFSET))).switchIfEmpty(Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(tokenRequestContext, (PublicClientApplication)publicClientApplication, iAccount, true)).map(MsalToken::new)));
    }

    private CompletableFuture<IAuthenticationResult> acquireTokenFromPublicClientSilently(TokenRequestContext tokenRequestContext, PublicClientApplication publicClientApplication, IAccount iAccount, boolean bl2) {
        SilentParameters.SilentParametersBuilder silentParametersBuilder = SilentParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()));
        if (bl2) {
            silentParametersBuilder.forceRefresh(true);
        }
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            silentParametersBuilder.claims(claimsRequest);
            silentParametersBuilder.forceRefresh(true);
        }
        if (iAccount != null) {
            silentParametersBuilder = silentParametersBuilder.account(iAccount);
        }
        silentParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        try {
            return publicClientApplication.acquireTokenSilently(silentParametersBuilder.build());
        }
        catch (MalformedURLException malformedURLException) {
            return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(malformedURLException)));
        }
    }

    private SynchronizedAccessor<PublicClientApplication> getPublicClientInstance(TokenRequestContext tokenRequestContext) {
        return tokenRequestContext.isCaeEnabled() ? this.publicClientApplicationAccessorWithCae : this.publicClientApplicationAccessor;
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext tokenRequestContext) {
        return this.authenticateWithConfidentialClientCache(tokenRequestContext, null);
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext tokenRequestContext, IAccount iAccount) {
        return this.getConfidentialClientInstance(tokenRequestContext).getValue().flatMap(confidentialClientApplication -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder silentParametersBuilder = SilentParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
            if (iAccount != null) {
                silentParametersBuilder.account(iAccount);
            }
            try {
                return confidentialClientApplication.acquireTokenSilently(silentParametersBuilder.build());
            }
            catch (MalformedURLException malformedURLException) {
                return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(malformedURLException)));
            }
        }).map(iAuthenticationResult -> new MsalToken((IAuthenticationResult)iAuthenticationResult)).filter(msalToken -> OffsetDateTime.now().isBefore(msalToken.getExpiresAt().minus(REFRESH_OFFSET))));
    }

    public Mono<MsalToken> authenticateWithDeviceCode(TokenRequestContext tokenRequestContext, Consumer<DeviceCodeInfo> consumer) {
        return this.getPublicClientInstance(tokenRequestContext).getValue().flatMap(publicClientApplication -> Mono.fromFuture(() -> {
            DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder deviceCodeFlowParametersBuilder = this.buildDeviceCodeFlowParameters(tokenRequestContext, consumer);
            return publicClientApplication.acquireToken(deviceCodeFlowParametersBuilder.build());
        }).onErrorMap(throwable -> new ClientAuthenticationException("Failed to acquire token with device code.", null, (Throwable)throwable)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithVsCodeCredential(TokenRequestContext tokenRequestContext, String string) {
        if (this.isADFSTenant()) {
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("VsCodeCredential  authentication unavailable. ADFS tenant/authorities are not supported. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot")));
        }
        VisualStudioCacheAccessor visualStudioCacheAccessor = new VisualStudioCacheAccessor();
        String string2 = null;
        try {
            string2 = visualStudioCacheAccessor.getCredentials("VS Code Azure", string);
        }
        catch (CredentialUnavailableException credentialUnavailableException) {
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, credentialUnavailableException));
        }
        RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()), string2);
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            refreshTokenParametersBuilder.claims(claimsRequest);
        }
        return this.getPublicClientInstance(tokenRequestContext).getValue().flatMap(publicClientApplication -> Mono.fromFuture(publicClientApplication.acquireToken(refreshTokenParametersBuilder.build())).onErrorResume(throwable -> {
            if (throwable instanceof MsalInteractionRequiredException) {
                return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Failed to acquire token with VS code credential. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot", (Throwable)throwable)));
            }
            return Mono.error((Throwable)new ClientAuthenticationException("Failed to acquire token with VS code credential", null, (Throwable)throwable));
        }).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(TokenRequestContext tokenRequestContext, String string, URI uRI) {
        ClaimsRequest claimsRequest;
        AuthorizationCodeParameters.AuthorizationCodeParametersBuilder authorizationCodeParametersBuilder = AuthorizationCodeParameters.builder(string, uRI).scopes(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (tokenRequestContext.getClaims() != null) {
            claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            authorizationCodeParametersBuilder.claims(claimsRequest);
        }
        if (this.clientSecret != null) {
            claimsRequest = this.getConfidentialClientInstance(tokenRequestContext).getValue().flatMap(confidentialClientApplication -> Mono.fromFuture(() -> confidentialClientApplication.acquireToken(authorizationCodeParametersBuilder.build())));
        } else {
            SynchronizedAccessor<PublicClientApplication> synchronizedAccessor = this.getPublicClientInstance(tokenRequestContext);
            claimsRequest = synchronizedAccessor.getValue().flatMap(publicClientApplication -> Mono.fromFuture(() -> publicClientApplication.acquireToken(authorizationCodeParametersBuilder.build())));
        }
        return claimsRequest.onErrorMap(throwable -> new ClientAuthenticationException("Failed to acquire token with authorization code", null, (Throwable)throwable)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(TokenRequestContext tokenRequestContext, Integer n2, String string, String string2) {
        URI uRI;
        String string3 = n2 != null ? "http://localhost:" + n2 : (string != null ? string : "http://localhost");
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException(uRISyntaxException)));
        }
        return this.getPublicClientInstance(tokenRequestContext).getValue().flatMap(publicClientApplication -> {
            if (this.options.isBrokerEnabled() && this.options.useDefaultBrokerAccount()) {
                return Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(tokenRequestContext, (PublicClientApplication)publicClientApplication, null, false)).onErrorResume(throwable -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            InteractiveRequestParameters.InteractiveRequestParametersBuilder interactiveRequestParametersBuilder = this.buildInteractiveRequestParameters(tokenRequestContext, string2, uRI);
            SynchronizedAccessor<PublicClientApplication> synchronizedAccessor = this.getPublicClientInstance(tokenRequestContext);
            return synchronizedAccessor.getValue().flatMap(publicClientApplication -> Mono.fromFuture(() -> publicClientApplication.acquireToken(interactiveRequestParametersBuilder.build())));
        })).onErrorMap(throwable -> !(throwable instanceof ClientAuthenticationException), throwable -> {
            throw new ClientAuthenticationException("Failed to acquire token with Interactive Browser Authentication.", null, (Throwable)throwable);
        }).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithSharedTokenCache(TokenRequestContext tokenRequestContext, String string) {
        SynchronizedAccessor<PublicClientApplication> synchronizedAccessor = this.getPublicClientInstance(tokenRequestContext);
        return synchronizedAccessor.getValue().flatMap(publicClientApplication -> Mono.fromFuture(publicClientApplication::getAccounts)).onErrorMap(throwable -> new CredentialUnavailableException("Cannot get accounts from token cache. Error: " + throwable.getMessage(), (Throwable)throwable)).flatMap(set -> {
            HashMap<String, IAccount> hashMap = new HashMap<String, IAccount>();
            if (set.isEmpty()) {
                return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("SharedTokenCacheCredential authentication unavailable. No accounts were found in the cache.")));
            }
            for (IAccount iAccount : set) {
                if (string != null && !string.equals(iAccount.username())) continue;
                hashMap.putIfAbsent(iAccount.homeAccountId(), iAccount);
            }
            if (hashMap.isEmpty()) {
                return Mono.error((Throwable)new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. No account matching the specified username: %s was found in the cache.", string)));
            }
            if (hashMap.size() > 1) {
                if (string == null) {
                    return Mono.error((Throwable)new RuntimeException("SharedTokenCacheCredential authentication unavailable. Multiple accounts were found in the cache. Use username and tenant id to disambiguate."));
                }
                return Mono.error((Throwable)new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. Multiple accounts matching the specified username: %s were found in the cache.", string)));
            }
            IAccount iAccount = (IAccount)hashMap.values().iterator().next();
            return this.authenticateWithPublicClientCache(tokenRequestContext, iAccount);
        });
    }

    private Mono<AccessToken> authenticateToArcManagedIdentityEndpoint(String string, TokenRequestContext tokenRequestContext) {
        return Mono.fromCallable(() -> {
            Object object;
            String string2;
            URL uRL;
            HttpURLConnection httpURLConnection;
            block14: {
                int n2;
                httpURLConnection = null;
                String string3 = string + "?resource=" + IdentityClient.urlEncode(ScopeUtil.scopesToResource(tokenRequestContext.getScopes())) + "&api-version=" + "2019-11-01";
                uRL = IdentityClient.getUrl(string3);
                string2 = null;
                try {
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setRequestProperty("Metadata", "true");
                    httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
                    httpURLConnection.connect();
                }
                catch (IOException iOException) {
                    if (httpURLConnection == null) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to initialize Http URL connection to the endpoint.", null, iOException));
                    }
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 != 401) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException(String.format("Expected a 401 Unauthorized response from Azure Arc Managed Identity Endpoint, received: %d", n2), null, iOException));
                    }
                }
                finally {
                    object = httpURLConnection.getHeaderField("WWW-Authenticate");
                    if (object == null) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Did not receive a value for WWW-Authenticate header in the response from Azure Arc Managed Identity Endpoint", null));
                    }
                    n2 = ((String)object).indexOf("=");
                    if (n2 == -1) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Did not receive a correct value for WWW-Authenticate header in the response from Azure Arc Managed Identity Endpoint", null));
                    }
                    String string4 = ((String)object).substring(n2 + 1);
                    Path path = ValidationUtil.validateSecretFile(new File(string4), LOGGER);
                    string2 = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    if (string2 != null) break block14;
                    throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Did not receive a secret value in the response from Azure Arc Managed Identity Endpoint", null));
                }
            }
            try {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
                httpURLConnection.setRequestProperty("Metadata", "true");
                httpURLConnection.connect();
                object = (AccessToken)SERIALIZER_ADAPTER.deserialize(httpURLConnection.getInputStream(), (Type)((Object)MSIToken.class), SerializerEncoding.JSON);
                return object;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateWithExchangeToken(TokenRequestContext tokenRequestContext) {
        return this.clientAssertionAccessor.getValue().flatMap(string -> Mono.fromCallable(() -> this.authenticateWithExchangeTokenHelper(tokenRequestContext, (String)string)));
    }

    private Mono<AccessToken> authenticateToServiceFabricManagedIdentityEndpoint(String string, String string2, String string3, TokenRequestContext tokenRequestContext) {
        return Mono.fromCallable(() -> {
            HttpURLConnection httpURLConnection = null;
            String string4 = ScopeUtil.scopesToResource(tokenRequestContext.getScopes());
            StringBuilder stringBuilder = new StringBuilder(1024).append(string);
            stringBuilder.append("?resource=");
            stringBuilder.append(IdentityClient.urlEncode(string4));
            stringBuilder.append("&api-version=");
            stringBuilder.append("2019-07-01-preview");
            if (this.clientId != null) {
                LOGGER.warning("User assigned managed identities are not supported in the Service Fabric environment.");
                stringBuilder.append("&client_id=");
                stringBuilder.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                LOGGER.warning("User assigned managed identities are not supported in the Service Fabric environment.");
                stringBuilder.append("&mi_res_id=");
                stringBuilder.append(IdentityClient.urlEncode(this.resourceId));
            }
            try {
                URL uRL = IdentityClient.getUrl(stringBuilder.toString());
                httpURLConnection = (HttpsURLConnection)uRL.openConnection();
                IdentitySslUtil.addTrustedCertificateThumbprint((HttpsURLConnection)httpURLConnection, string3, LOGGER);
                httpURLConnection.setRequestMethod("GET");
                if (string2 != null) {
                    httpURLConnection.setRequestProperty("Secret", string2);
                }
                httpURLConnection.setRequestProperty("Metadata", "true");
                httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
                httpURLConnection.connect();
                AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(httpURLConnection.getInputStream(), (Type)((Object)MSIToken.class), SerializerEncoding.JSON);
                return accessToken;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToManagedIdentityEndpoint(String string, String string2, String string3, String string4, TokenRequestContext tokenRequestContext) {
        return Mono.fromCallable(() -> {
            String string5;
            String string6;
            String string7;
            if (string != null) {
                string7 = string;
                string6 = string2;
                string5 = "2019-08-01";
            } else {
                string7 = string3;
                string6 = string4;
                string5 = "2017-09-01";
            }
            String string8 = ScopeUtil.scopesToResource(tokenRequestContext.getScopes());
            HttpURLConnection httpURLConnection = null;
            StringBuilder stringBuilder = new StringBuilder(1024).append(string7);
            stringBuilder.append("?resource=");
            stringBuilder.append(IdentityClient.urlEncode(string8));
            stringBuilder.append("&api-version=");
            stringBuilder.append(URLEncoder.encode(string5, StandardCharsets.UTF_8.name()));
            if (this.clientId != null) {
                if (string5.equals("2019-08-01")) {
                    stringBuilder.append("&client_id=");
                } else {
                    if (string6 == null) {
                        LOGGER.warning("User assigned managed identities are not supported in the Cloud Shell environment.");
                    }
                    stringBuilder.append("&clientid=");
                }
                stringBuilder.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                if (string5.equals("2017-09-01") && string6 == null) {
                    LOGGER.warning("User assigned managed identities are not supported in the Cloud Shell environment.");
                }
                stringBuilder.append("&mi_res_id=");
                stringBuilder.append(IdentityClient.urlEncode(this.resourceId));
            }
            try {
                URL uRL = IdentityClient.getUrl(stringBuilder.toString());
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                if (string6 != null) {
                    if ("2019-08-01".equals(string5)) {
                        httpURLConnection.setRequestProperty("X-IDENTITY-HEADER", string6);
                    } else {
                        httpURLConnection.setRequestProperty("Secret", string6);
                    }
                }
                httpURLConnection.setRequestProperty("Metadata", "true");
                httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
                httpURLConnection.connect();
                AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(httpURLConnection.getInputStream(), (Type)((Object)MSIToken.class), SerializerEncoding.JSON);
                return accessToken;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToIMDSEndpoint(TokenRequestContext tokenRequestContext) {
        String string = ScopeUtil.scopesToResource(tokenRequestContext.getScopes());
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 70000;
        try {
            stringBuilder.append("api-version=2018-02-01");
            stringBuilder.append("&resource=");
            stringBuilder.append(IdentityClient.urlEncode(string));
            if (this.clientId != null) {
                stringBuilder.append("&client_id=");
                stringBuilder.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                stringBuilder.append("&mi_res_id=");
                stringBuilder.append(IdentityClient.urlEncode(this.resourceId));
            }
        }
        catch (IOException iOException) {
            return Mono.error((Throwable)iOException);
        }
        String string2 = TRAILING_FORWARD_SLASHES.matcher(this.options.getImdsAuthorityHost()).replaceAll("") + "/metadata/identity/oauth2/token";
        return this.checkIMDSAvailable(string2).flatMap(bl2 -> Mono.fromCallable(() -> {
            int n2 = 1;
            while (n2 <= this.options.getMaxRetry()) {
                URL uRL = null;
                HttpURLConnection httpURLConnection = null;
                try {
                    uRL = IdentityClient.getUrl(string2 + "?" + stringBuilder);
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setRequestProperty("Metadata", "true");
                    httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
                    httpURLConnection.connect();
                    AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(httpURLConnection.getInputStream(), (Type)((Object)MSIToken.class), SerializerEncoding.JSON);
                    return accessToken;
                }
                catch (IOException iOException) {
                    int n3;
                    if (httpURLConnection == null) {
                        throw LOGGER.logExceptionAsError(new RuntimeException("Could not connect to the url: " + uRL + ".", iOException));
                    }
                    try {
                        n3 = httpURLConnection.getResponseCode();
                    }
                    catch (Exception exception) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + exception.getMessage() + ".", (Throwable)exception));
                    }
                    if (n3 == 400) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established.", null));
                    }
                    if (n3 == 403 && httpURLConnection.getResponseMessage().contains("A socket operation was attempted to an unreachable network")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Managed Identity response was not in the expected format. See the inner exception for details.", (Throwable)new Exception(httpURLConnection.getResponseMessage())));
                    }
                    if (n3 == 410 || n3 == 429 || n3 == 404 || n3 >= 500 && n3 <= 599) {
                        int n4 = this.getRetryTimeoutInMs(n2);
                        int n5 = n4 = n3 == 410 && n4 < 70000 ? 70000 : n4;
                        if (++n2 > this.options.getMaxRetry()) break;
                        IdentityClient.sleep(n4);
                        continue;
                    }
                    throw LOGGER.logExceptionAsError(new RuntimeException("Couldn't acquire access token from IMDS, verify your objectId, clientId or msiResourceId", iOException));
                }
                finally {
                    if (httpURLConnection == null) continue;
                    httpURLConnection.disconnect();
                }
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("MSI: Failed to acquire tokens after retrying %s times", this.options.getMaxRetry())));
        }));
    }

    int getRetryTimeoutInMs(int n2) {
        return (int)this.options.getRetryTimeout().apply(Duration.ofSeconds(n2)).toMillis();
    }

    private Mono<Boolean> checkIMDSAvailable(String string) {
        return Mono.fromCallable(() -> {
            HttpURLConnection httpURLConnection = null;
            URL uRL = IdentityClient.getUrl(string + "?api-version=2018-02-01");
            try {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setConnectTimeout(1000);
                httpURLConnection.connect();
            }
            catch (Exception exception) {
                throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + exception.getMessage() + ".", (Throwable)exception));
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            return true;
        });
    }

    private static void sleep(int n2) {
        try {
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions proxyOptions) {
        switch (proxyOptions.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, proxyOptions.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, proxyOptions.getAddress());
    }

    void openUrl(String string) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        String string2 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string2.contains("win")) {
            runtime.exec("rundll32 url.dll,FileProtocolHandler " + string);
        } else if (string2.contains("mac")) {
            runtime.exec("open " + string);
        } else if (string2.contains("nix") || string2.contains("nux")) {
            runtime.exec("xdg-open " + string);
        } else {
            LOGGER.error("Browser could not be opened - please open {} in a browser on this device.", string);
        }
    }

    private CompletableFuture<IAuthenticationResult> getFailedCompletableFuture(Exception exception) {
        CompletableFuture<IAuthenticationResult> completableFuture = new CompletableFuture<IAuthenticationResult>();
        completableFuture.completeExceptionally(exception);
        return completableFuture;
    }

    public IdentityClientOptions getIdentityClientOptions() {
        return this.options;
    }

    private boolean isADFSTenant() {
        return "adfs".equals(this.tenantId);
    }

    @Override
    Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider() {
        return appTokenProviderParameters -> {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().setScopes(new ArrayList<String>(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> mono = this.authenticateWithExchangeToken(tokenRequestContext);
            return mono.map(accessToken -> {
                TokenProviderResult tokenProviderResult = new TokenProviderResult();
                tokenProviderResult.setAccessToken(accessToken.getToken());
                tokenProviderResult.setTenantId(tokenRequestContext.getTenantId());
                tokenProviderResult.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return tokenProviderResult;
            }).toFuture();
        };
    }
}

