/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.VisualStudioCacheAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class VisualStudioCodeCredential
implements TokenCredential {
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;
    private final String cloudInstance;
    private static final ClientLogger LOGGER = new ClientLogger(VisualStudioCodeCredential.class);
    private static final String TROUBLESHOOTING = "VisualStudioCodeCredential is affected by known issues. See https://aka.ms/azsdk/java/identity/troubleshoot#troubleshoot-visualstudiocodecredential-authentication-issues for more information.";

    VisualStudioCodeCredential(String string, IdentityClientOptions identityClientOptions) {
        IdentityClientOptions identityClientOptions2 = identityClientOptions == null ? new IdentityClientOptions() : identityClientOptions;
        VisualStudioCacheAccessor visualStudioCacheAccessor = new VisualStudioCacheAccessor();
        Map<String, String> map = visualStudioCacheAccessor.getUserSettingsDetails();
        this.cloudInstance = map.get("cloud");
        if (CoreUtils.isNullOrEmpty(identityClientOptions2.getAuthorityHost())) {
            identityClientOptions2.setAuthorityHost(visualStudioCacheAccessor.getAzureAuthHost(this.cloudInstance));
        }
        String string2 = !CoreUtils.isNullOrEmpty(string) ? string : map.getOrDefault("tenant", "common");
        this.identityClient = new IdentityClientBuilder().tenantId(string2).clientId("aebc6443-996d-45c2-90f0-388ff96faa56").identityClientOptions(identityClientOptions2).build();
        this.cachedToken = new AtomicReference();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(tokenRequestContext, this.cachedToken.get().getAccount()).onErrorResume(throwable -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithVsCodeCredential(tokenRequestContext, this.cloudInstance))).map(msalToken -> {
            this.cachedToken.set((MsalToken)msalToken);
            return msalToken;
        }).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> {
            Throwable throwable2 = null;
            throwable2 = throwable instanceof CredentialUnavailableException ? new CredentialUnavailableException(TROUBLESHOOTING, (Throwable)throwable) : (throwable instanceof ClientAuthenticationException ? new ClientAuthenticationException(TROUBLESHOOTING, null, (Throwable)throwable) : throwable);
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable2);
        });
    }
}

