/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AadCredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.OnBehalfOfCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class OnBehalfOfCredentialBuilder
extends AadCredentialBuilderBase<OnBehalfOfCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(OnBehalfOfCredentialBuilder.class);
    private static final String CLASS_NAME = OnBehalfOfCredentialBuilder.class.getSimpleName();
    private String clientSecret;
    private String clientCertificatePath;
    private String clientCertificatePassword;

    public OnBehalfOfCredentialBuilder clientSecret(String string) {
        this.clientSecret = string;
        return this;
    }

    public OnBehalfOfCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public OnBehalfOfCredentialBuilder pemCertificate(String string) {
        this.clientCertificatePath = string;
        return this;
    }

    public OnBehalfOfCredentialBuilder pfxCertificate(String string) {
        this.clientCertificatePath = string;
        return this;
    }

    public OnBehalfOfCredentialBuilder clientCertificatePassword(String string) {
        this.clientCertificatePassword = string;
        return this;
    }

    public OnBehalfOfCredentialBuilder sendCertificateChain(boolean bl2) {
        this.identityClientOptions.setIncludeX5c(bl2);
        return this;
    }

    public OnBehalfOfCredentialBuilder userAssertion(String string) {
        this.identityClientOptions.userAssertion(string);
        return this;
    }

    public OnBehalfOfCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "tenantId", this.tenantId);
        if (this.clientSecret == null && this.clientCertificatePath == null) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("At least client secret or certificate path should provided in OnBehalfOfCredentialBuilder. Only one of them should be provided."));
        }
        if (this.clientCertificatePath != null && this.clientSecret != null) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Both client secret and certificate path are provided in OnBehalfCredentialBuilder. Only one of them should be provided."));
        }
        return new OnBehalfOfCredential(this.clientId, this.tenantId, this.clientSecret, this.clientCertificatePath, this.clientCertificatePassword, this.identityClientOptions);
    }
}

