/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AadCredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRecord;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.BrowserCustomizationOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.InteractiveBrowserCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class InteractiveBrowserCredentialBuilder
extends AadCredentialBuilderBase<InteractiveBrowserCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(InteractiveBrowserCredentialBuilder.class);
    private Integer port;
    private boolean automaticAuthentication = true;
    private String redirectUrl;
    private String loginHint;

    @Deprecated
    public InteractiveBrowserCredentialBuilder port(int n2) {
        this.port = n2;
        return this;
    }

    InteractiveBrowserCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    InteractiveBrowserCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public InteractiveBrowserCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        this.identityClientOptions.setAuthenticationRecord(authenticationRecord);
        return this;
    }

    public InteractiveBrowserCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public InteractiveBrowserCredentialBuilder redirectUrl(String string) {
        this.redirectUrl = string;
        return this;
    }

    public InteractiveBrowserCredentialBuilder disableAutomaticAuthentication() {
        this.automaticAuthentication = false;
        return this;
    }

    public InteractiveBrowserCredentialBuilder loginHint(String string) {
        this.loginHint = string;
        return this;
    }

    @Override
    public InteractiveBrowserCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    @Override
    public InteractiveBrowserCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }

    public InteractiveBrowserCredentialBuilder browserCustomizationOptions(BrowserCustomizationOptions browserCustomizationOptions) {
        this.identityClientOptions.setBrowserCustomizationOptions(browserCustomizationOptions);
        return this;
    }

    public InteractiveBrowserCredential build() {
        ValidationUtil.validateInteractiveBrowserRedirectUrlSetup(this.port, this.redirectUrl, LOGGER);
        String string = this.clientId != null ? this.clientId : "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
        return new InteractiveBrowserCredential(string, this.tenantId, this.port, this.redirectUrl, this.automaticAuthentication, this.loginHint, this.identityClientOptions);
    }
}

