/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzurePowerShellCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class AzurePowerShellCredentialBuilder
extends CredentialBuilderBase<AzurePowerShellCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePowerShellCredentialBuilder.class);
    private String tenantId;

    public AzurePowerShellCredentialBuilder tenantId(String string) {
        ValidationUtil.validateTenantIdCharacterRange(string, LOGGER);
        this.tenantId = string;
        return this;
    }

    public AzurePowerShellCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    public AzurePowerShellCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }

    public AzurePowerShellCredential build() {
        return new AzurePowerShellCredential(this.tenantId, this.identityClientOptions);
    }
}

