/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentitySyncClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class AzureCliCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzureCliCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    AzureCliCredential(String string, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder identityClientBuilder = new IdentityClientBuilder().tenantId(string).identityClientOptions(identityClientOptions);
        this.identityClient = identityClientBuilder.build();
        this.identitySyncClient = identityClientBuilder.buildSyncClient();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return this.identityClient.authenticateWithAzureCli(tokenRequestContext).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable)).onErrorMap(throwable -> {
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                return new CredentialUnavailableException(throwable.getMessage(), (Throwable)throwable);
            }
            return throwable;
        });
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        try {
            AccessToken accessToken = this.identitySyncClient.authenticateWithAzureCli(tokenRequestContext);
            LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
            return accessToken;
        }
        catch (Exception exception) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, exception);
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                throw new CredentialUnavailableException(exception.getMessage(), (Throwable)exception);
            }
            throw exception;
        }
    }
}

