/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ManagedIdentityServiceCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

class ArcIdentityCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ArcIdentityCredential.class);
    private final String identityEndpoint;

    ArcIdentityCredential(String string, IdentityClient identityClient) {
        super(string, identityClient, "AZURE ARC IDENTITY ENDPOINT");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.identityEndpoint = configuration.get("IDENTITY_ENDPOINT");
        if (this.identityEndpoint != null) {
            this.validateEndpointProtocol(this.identityEndpoint, "Identity", LOGGER);
        }
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext tokenRequestContext) {
        if (this.getClientId() != null) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError(new ClientAuthenticationException("User assigned identity is not supported by the Azure Arc Managed Identity Endpoint. To authenticate with the system assigned identity omit the client id when constructing the ManagedIdentityCredential.", null)));
        }
        return this.identityClient.authenticateWithManagedIdentityConfidentialClient(tokenRequestContext);
    }
}

