/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer;

import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

public enum SerializerEncoding {
    JSON,
    XML,
    TEXT;

    private static final ClientLogger LOGGER;

    public static SerializerEncoding fromHeaders(HttpHeaders httpHeaders) {
        String string = httpHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        if (CoreUtils.isNullOrEmpty(string)) {
            LOGGER.verbose("'Content-Type' not found. Returning default encoding: JSON");
            return JSON;
        }
        int n2 = string.indexOf(59);
        String string2 = n2 == -1 ? string : string.substring(0, n2);
        SerializerEncoding serializerEncoding = SerializerEncoding.checkForKnownEncoding(string2);
        if (serializerEncoding != null) {
            return serializerEncoding;
        }
        int n3 = string2.indexOf(47);
        if (n3 == -1) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Content-Type '" + string2 + "' does not match mime-type formatting 'type'/'subtype'. Returning default: JSON");
            return JSON;
        }
        String string3 = string2.substring(n3 + 1);
        int n4 = string3.lastIndexOf(43);
        if (n4 == -1) {
            return JSON;
        }
        String string4 = string3.substring(n4 + 1);
        if ("xml".equalsIgnoreCase(string4)) {
            return XML;
        }
        if ("json".equalsIgnoreCase(string4)) {
            return JSON;
        }
        LOGGER.log(LogLevel.VERBOSE, () -> "Content-Type '" + string4 + "' does not match any supported one. Returning default: JSON");
        return JSON;
    }

    private static SerializerEncoding checkForKnownEncoding(String string) {
        int n2 = string.length();
        if (n2 != 8 && n2 != 9 && n2 != 10 && n2 != 15 && n2 != 16) {
            return null;
        }
        if ("text/".regionMatches(true, 0, string, 0, 5)) {
            if (n2 == 8) {
                if ("xml".regionMatches(true, 0, string, 5, 3)) {
                    return XML;
                }
                if ("csv".regionMatches(true, 0, string, 5, 3)) {
                    return TEXT;
                }
                if ("css".regionMatches(true, 0, string, 5, 3)) {
                    return TEXT;
                }
            } else {
                if (n2 == 9 && "html".regionMatches(true, 0, string, 5, 4)) {
                    return TEXT;
                }
                if (n2 == 10 && "plain".regionMatches(true, 0, string, 5, 5)) {
                    return TEXT;
                }
                if (n2 == 15 && "javascript".regionMatches(true, 0, string, 5, 10)) {
                    return TEXT;
                }
            }
        } else if ("application/".regionMatches(true, 0, string, 0, 12)) {
            if (n2 == 16 && "json".regionMatches(true, 0, string, 12, 4)) {
                return JSON;
            }
            if (n2 == 15 && "xml".regionMatches(true, 0, string, 12, 3)) {
                return XML;
            }
        }
        return null;
    }

    static {
        LOGGER = new ClientLogger(SerializerEncoding.class);
    }
}

