/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.CollectionFormat;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;

public interface SerializerAdapter {
    public String serialize(Object var1, SerializerEncoding var2) throws IOException;

    default public byte[] serializeToBytes(Object object, SerializerEncoding serializerEncoding) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.serialize(object, serializerEncoding, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    default public void serialize(Object object, SerializerEncoding serializerEncoding, OutputStream outputStream) throws IOException {
        String string = this.serialize(object, serializerEncoding);
        if (string != null) {
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String serializeRaw(Object var1);

    public String serializeList(List<?> var1, CollectionFormat var2);

    default public String serializeIterable(Iterable<?> iterable, CollectionFormat collectionFormat) {
        if (iterable == null) {
            return null;
        }
        return StreamSupport.stream(iterable.spliterator(), false).map(this::serializeRaw).map(string -> string == null ? "" : string).collect(Collectors.joining(collectionFormat.getDelimiter()));
    }

    public <T> T deserialize(String var1, Type var2, SerializerEncoding var3) throws IOException;

    default public <T> T deserialize(byte[] byArray, Type type, SerializerEncoding serializerEncoding) throws IOException {
        return this.deserialize(new String(byArray, StandardCharsets.UTF_8), type, serializerEncoding);
    }

    default public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding serializerEncoding) throws IOException {
        int n2;
        if (inputStream == null) {
            return this.deserialize((String)null, type, serializerEncoding);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return this.deserialize(byteArrayOutputStream.toString(StandardCharsets.UTF_8.name()), type, serializerEncoding);
    }

    public <T> T deserialize(HttpHeaders var1, Type var2) throws IOException;

    default public <T> T deserializeHeader(Header header, Type type) throws IOException {
        return this.deserialize(new HttpHeaders().add(header.getName(), header.getValue()), type);
    }
}

