/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer;

import java.util.Iterator;
import java.util.ServiceLoader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializerProvider;

public final class JsonSerializerProviders {
    private static final String CANNOT_FIND_JSON_SERIALIZER_PROVIDER = "A request was made to load the default JSON serializer provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-serializer-json-jackson or azure-core-serializer-json-gson. Depending on your existing dependencies, you have the choice of Jackson or GSON implementations. Additionally, refer to https://aka.ms/azsdk/java/docs/custom-jsonserializer to learn about writing your own implementation.";
    private static JsonSerializerProvider jsonSerializerProvider;
    private static boolean attemptedLoad;

    public static JsonSerializer createInstance() {
        return JsonSerializerProviders.createInstance(false);
    }

    public static JsonSerializer createInstance(boolean bl2) {
        if (jsonSerializerProvider == null) {
            JsonSerializerProviders.loadDefaultSerializer();
        }
        if (jsonSerializerProvider != null) {
            return jsonSerializerProvider.createInstance();
        }
        if (bl2) {
            return new DefaultJsonSerializer();
        }
        throw new IllegalStateException(CANNOT_FIND_JSON_SERIALIZER_PROVIDER);
    }

    private static synchronized void loadDefaultSerializer() {
        if (attemptedLoad) {
            return;
        }
        attemptedLoad = true;
        Iterator<JsonSerializerProvider> iterator = ServiceLoader.load(JsonSerializerProvider.class, JsonSerializerProviders.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            jsonSerializerProvider = iterator.next();
        }
    }

    private JsonSerializerProviders() {
    }
}

