/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SimpleSyncPoller;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;

public interface SyncPoller<T, U> {
    public PollResponse<T> poll();

    public PollResponse<T> waitForCompletion();

    public PollResponse<T> waitForCompletion(Duration var1);

    public PollResponse<T> waitUntil(LongRunningOperationStatus var1);

    public PollResponse<T> waitUntil(Duration var1, LongRunningOperationStatus var2);

    public U getFinalResult();

    default public U getFinalResult(Duration duration) {
        return this.getFinalResult();
    }

    public void cancelOperation();

    default public SyncPoller<T, U> setPollInterval(Duration duration) {
        return this;
    }

    public static <T, U> SyncPoller<T, U> createPoller(Duration duration, Function<PollingContext<T>, PollResponse<T>> function, Function<PollingContext<T>, PollResponse<T>> function2, BiFunction<PollingContext<T>, PollResponse<T>, T> biFunction, Function<PollingContext<T>, U> function3) {
        return new SimpleSyncPoller<T, U>(duration, function, function2, biFunction, function3);
    }

    public static <T, U> SyncPoller<T, U> createPoller(Duration duration, Supplier<Response<?>> supplier, SyncPollingStrategy<T, U> syncPollingStrategy, TypeReference<T> typeReference, TypeReference<U> typeReference2) {
        Function<PollingContext<T>, PollResponse<T>> function = pollingContext -> {
            Response response = (Response)supplier.get();
            if (!syncPollingStrategy.canPoll(response)) {
                throw new IllegalStateException("Cannot poll with strategy " + syncPollingStrategy.getClass().getSimpleName());
            }
            return syncPollingStrategy.onInitialResponse(response, (PollingContext)pollingContext, typeReference);
        };
        Function<PollingContext<T>, PollResponse<T>> function2 = pollingContext -> syncPollingStrategy.poll((PollingContext)pollingContext, typeReference);
        BiFunction<PollingContext, PollResponse, Object> biFunction = syncPollingStrategy::cancel;
        Function<PollingContext, Object> function3 = pollingContext -> syncPollingStrategy.getResult((PollingContext)pollingContext, typeReference2);
        return SyncPoller.createPoller(duration, function, function2, biFunction, function3);
    }
}

