/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.AzureException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollResult;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;

public class SyncOperationResourcePollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncOperationResourcePollingStrategy.class);
    private static final HttpHeaderName DEFAULT_OPERATION_LOCATION_HEADER = HttpHeaderName.fromString("Operation-Location");
    private static final TypeReference<PollResult> POLL_RESULT_TYPE_REFERENCE = TypeReference.createInstance(PollResult.class);
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final String endpoint;
    private final HttpHeaderName operationLocationHeaderName;
    private final Context context;
    private final String serviceVersion;

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline) {
        this(DEFAULT_OPERATION_LOCATION_HEADER, new PollingStrategyOptions(httpPipeline));
    }

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer objectSerializer, String string) {
        this(httpPipeline, objectSerializer, string, Context.NONE);
    }

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer objectSerializer, String string, Context context) {
        this(httpPipeline, null, objectSerializer, string, context);
    }

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline, String string, ObjectSerializer objectSerializer, String string2, Context context) {
        this(string2 == null ? null : HttpHeaderName.fromString(string2), new PollingStrategyOptions(httpPipeline).setEndpoint(string).setSerializer(objectSerializer).setContext(context));
    }

    public SyncOperationResourcePollingStrategy(HttpHeaderName httpHeaderName, PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.httpPipeline = pollingStrategyOptions.getHttpPipeline();
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() != null ? pollingStrategyOptions.getSerializer() : new DefaultJsonSerializer();
        this.operationLocationHeaderName = httpHeaderName == null ? DEFAULT_OPERATION_LOCATION_HEADER : httpHeaderName;
        this.serviceVersion = pollingStrategyOptions.getServiceVersion();
        this.context = pollingStrategyOptions.getContext() == null ? Context.NONE : pollingStrategyOptions.getContext();
    }

    @Override
    public boolean canPoll(Response<?> response) {
        return PollingUtil.operationResourceCanPoll(response, this.operationLocationHeaderName, this.endpoint, LOGGER);
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        HttpHeader httpHeader = response.getHeaders().get(this.operationLocationHeaderName);
        HttpHeader httpHeader2 = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (httpHeader != null) {
            pollingContext.setData(this.operationLocationHeaderName.getCaseSensitiveName(), PollingUtils.getAbsolutePath(httpHeader.getValue(), this.endpoint, LOGGER));
        }
        if (httpHeader2 != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(httpHeader2.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration duration = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return new PollResponse<T>(LongRunningOperationStatus.IN_PROGRESS, PollingUtils.convertResponseSync(response.getValue(), this.serializer, typeReference), duration);
        }
        throw LOGGER.logExceptionAsError(new AzureException(String.format("Operation failed or cancelled with status code %d, '%s' header: %s, and response body: %s", response.getStatusCode(), this.operationLocationHeaderName, httpHeader, PollingUtils.serializeResponseSync(response.getValue(), this.serializer))));
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        String string = pollingContext.getData(this.operationLocationHeaderName.getCaseSensitiveName());
        string = this.setServiceVersionQueryParam(string);
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string);
        try (HttpResponse httpResponse = this.httpPipeline.sendSync(httpRequest, this.context);){
            BinaryData binaryData = httpResponse.getBodyAsBinaryData();
            PollResult pollResult = PollingUtils.deserializeResponseSync(binaryData, this.serializer, POLL_RESULT_TYPE_REFERENCE);
            String string2 = pollResult.getResourceLocation();
            if (string2 != null) {
                pollingContext.setData("resourceLocation", PollingUtils.getAbsolutePath(string2, this.endpoint, LOGGER));
            }
            pollingContext.setData("pollResponseBody", binaryData.toString());
            Duration duration = ImplUtils.getRetryAfterFromHeaders(httpResponse.getHeaders(), OffsetDateTime::now);
            PollResponse<T> pollResponse = new PollResponse<T>(pollResult.getStatus(), PollingUtils.deserializeResponseSync(binaryData, this.serializer, typeReference), duration);
            return pollResponse;
        }
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        Object object;
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            throw LOGGER.logExceptionAsError(new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            throw LOGGER.logExceptionAsError(new AzureException("Long running operation cancelled."));
        }
        String string = pollingContext.getData("resourceLocation");
        if (string == null) {
            object = pollingContext.getData("httpMethod");
            if (HttpMethod.PUT.name().equalsIgnoreCase((String)object) || HttpMethod.PATCH.name().equalsIgnoreCase((String)object)) {
                string = pollingContext.getData("requestURL");
            } else if (HttpMethod.POST.name().equalsIgnoreCase((String)object)) {
                string = pollingContext.getData("Location");
            } else {
                throw LOGGER.logExceptionAsError(new AzureException("Cannot get final result"));
            }
        }
        if (string == null) {
            object = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponseSync(BinaryData.fromString((String)object), this.serializer, typeReference);
        }
        string = this.setServiceVersionQueryParam(string);
        object = new HttpRequest(HttpMethod.GET, string);
        try (HttpResponse httpResponse = this.httpPipeline.sendSync((HttpRequest)object, this.context);){
            BinaryData binaryData = httpResponse.getBodyAsBinaryData();
            U u2 = PollingUtils.deserializeResponseSync(binaryData, this.serializer, typeReference);
            return u2;
        }
    }

    private String setServiceVersionQueryParam(String string) {
        if (!CoreUtils.isNullOrEmpty(this.serviceVersion)) {
            UrlBuilder urlBuilder = UrlBuilder.parse(string);
            urlBuilder.setQueryParameter("api-version", this.serviceVersion);
            string = urlBuilder.toString();
        }
        return string;
    }
}

