/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPoller;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollContextRequiredException;

final class SimpleSyncPoller<T, U>
implements SyncPoller<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SimpleSyncPoller.class);
    private final Function<PollingContext<T>, PollResponse<T>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, T> cancelOperation;
    private final Function<PollingContext<T>, U> fetchResultOperation;
    private final PollResponse<T> activationResponse;
    private final PollingContext<T> pollingContext = new PollingContext();
    private final Semaphore pollingSemaphore = new Semaphore(1);
    private volatile PollingContext<T> terminalPollContext;
    private volatile Duration pollInterval;

    SimpleSyncPoller(Duration duration, Function<PollingContext<T>, PollResponse<T>> function, Function<PollingContext<T>, PollResponse<T>> function2, BiFunction<PollingContext<T>, PollResponse<T>, T> biFunction, Function<PollingContext<T>, U> function3) {
        Objects.requireNonNull(duration, "'pollInterval' cannot be null.");
        if (duration.isNegative() || duration.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = duration;
        Objects.requireNonNull(function, "'syncActivationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(function2, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(biFunction, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(function3, "'fetchResultOperation' cannot be null.");
        this.activationResponse = function.apply(this.pollingContext);
        this.pollingContext.setOnetimeActivationResponse(this.activationResponse);
        this.pollingContext.setLatestResponse(this.activationResponse);
        if (this.activationResponse.getStatus().isComplete()) {
            this.terminalPollContext = this.pollingContext;
        }
    }

    @Override
    public PollResponse<T> poll() {
        try {
            this.pollingSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw LOGGER.logExceptionAsError(new RuntimeException(interruptedException));
        }
        try {
            PollResponse<T> pollResponse = this.pollOperation.apply(this.pollingContext);
            this.pollingContext.setLatestResponse(pollResponse);
            if (pollResponse.getStatus().isComplete()) {
                this.terminalPollContext = this.pollingContext.copy();
            }
            PollResponse<T> pollResponse2 = pollResponse;
            return pollResponse2;
        }
        finally {
            this.pollingSemaphore.release();
        }
    }

    @Override
    public PollResponse<T> waitForCompletion() {
        return this.waitForCompletionHelper(null);
    }

    @Override
    public PollResponse<T> waitForCompletion(Duration duration) {
        PollingUtil.validateTimeout(duration, LOGGER);
        return this.waitForCompletionHelper(duration);
    }

    @Override
    public PollResponse<T> waitUntil(LongRunningOperationStatus longRunningOperationStatus) {
        Objects.requireNonNull(longRunningOperationStatus, "'statusToWaitFor' cannot be null.");
        return this.waitUntilHelper(null, longRunningOperationStatus);
    }

    @Override
    public PollResponse<T> waitUntil(Duration duration, LongRunningOperationStatus longRunningOperationStatus) {
        PollingUtil.validateTimeout(duration, LOGGER);
        Objects.requireNonNull(longRunningOperationStatus, "'statusToWaitFor' cannot be null.");
        return this.waitUntilHelper(duration, longRunningOperationStatus);
    }

    private PollResponse<T> waitUntilHelper(Duration duration, LongRunningOperationStatus longRunningOperationStatus) {
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return pollingContext.getLatestResponse();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        PollResponse<T> pollResponse = PollingUtil.pollingLoop(pollingContext2, duration, longRunningOperationStatus, this.pollOperation, this.pollInterval, true);
        if (pollResponse.getStatus().isComplete()) {
            this.terminalPollContext = pollingContext2;
        }
        return pollResponse;
    }

    private PollResponse<T> waitForCompletionHelper(Duration duration) {
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return pollingContext.getLatestResponse();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        PollResponse<T> pollResponse = PollingUtil.pollingLoop(pollingContext2, duration, null, this.pollOperation, this.pollInterval, false);
        this.terminalPollContext = pollingContext2;
        return pollResponse;
    }

    @Override
    public U getFinalResult() {
        return this.getFinalResultHelper(null);
    }

    @Override
    public U getFinalResult(Duration duration) {
        PollingUtil.validateTimeout(duration, LOGGER);
        return this.getFinalResultHelper(duration);
    }

    private U getFinalResultHelper(Duration duration) {
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return this.fetchResultOperation.apply(pollingContext);
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        PollingUtil.pollingLoop(pollingContext2, duration, null, this.pollOperation, this.pollInterval, false);
        this.terminalPollContext = pollingContext2;
        return this.getFinalResult();
    }

    @Override
    public void cancelOperation() {
        PollingContext<T> pollingContext = this.pollingContext.copy();
        if (pollingContext.getActivationResponse() == pollingContext.getLatestResponse()) {
            this.cancelOperation.apply(pollingContext, pollingContext.getActivationResponse());
        } else {
            try {
                this.cancelOperation.apply(null, this.activationResponse);
            }
            catch (PollContextRequiredException pollContextRequiredException) {
                PollingContext<T> pollingContext2 = this.pollingContext.copy();
                PollingUtil.pollingLoop(this.pollingContext, null, null, this.pollOperation, this.pollInterval, false);
                this.cancelOperation.apply(pollingContext2, this.activationResponse);
            }
        }
    }

    @Override
    public SyncPoller<T, U> setPollInterval(Duration duration) {
        this.pollInterval = PollingUtil.validatePollInterval(duration, LOGGER);
        return this;
    }
}

