/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class AsyncPollResponse<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(AsyncPollResponse.class);
    private final PollingContext<T> pollingContext;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancellationOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final PollResponse<T> pollResponse;

    AsyncPollResponse(PollingContext<T> pollingContext, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> biFunction, Function<PollingContext<T>, Mono<U>> function) {
        this.pollingContext = Objects.requireNonNull(pollingContext, "'pollingContext' cannot be null.");
        this.cancellationOperation = Objects.requireNonNull(biFunction, "'cancellationOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(function, "'fetchResultOperation' cannot be null.");
        this.pollResponse = this.pollingContext.getLatestResponse();
    }

    public LongRunningOperationStatus getStatus() {
        return this.pollResponse.getStatus();
    }

    public T getValue() {
        return this.pollResponse.getValue();
    }

    public Mono<T> cancelOperation() {
        return Mono.defer(() -> {
            try {
                return this.cancellationOperation.apply(this.pollingContext, this.pollingContext.getActivationResponse());
            }
            catch (RuntimeException runtimeException) {
                return FluxUtil.monoError(LOGGER, runtimeException);
            }
        });
    }

    public Mono<U> getFinalResult() {
        return Mono.defer(() -> {
            if (!this.pollResponse.getStatus().isComplete()) {
                return Mono.empty();
            }
            try {
                return this.fetchResultOperation.apply(this.pollingContext);
            }
            catch (RuntimeException runtimeException) {
                return FluxUtil.monoError(LOGGER, runtimeException);
            }
        });
    }

    Duration getRetryAfter() {
        return this.pollResponse.getRetryAfter();
    }
}

