/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.IterableStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePage;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedFlux;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuationState;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetriever;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.reactor.core.CoreSubscriber;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public abstract class ContinuablePagedFluxCore<C, T, P extends ContinuablePage<C, T>>
extends ContinuablePagedFlux<C, T, P> {
    private static final ClientLogger LOGGER = new ClientLogger(ContinuablePagedFluxCore.class);
    final Supplier<PageRetriever<C, P>> pageRetrieverProvider;
    final Integer defaultPageSize;

    protected ContinuablePagedFluxCore(Supplier<PageRetriever<C, P>> supplier) {
        this(supplier, null, null);
    }

    protected ContinuablePagedFluxCore(Supplier<PageRetriever<C, P>> supplier, int n2) {
        this(supplier, n2, null);
    }

    protected ContinuablePagedFluxCore(Supplier<PageRetriever<C, P>> supplier, Integer n2, Predicate<C> predicate) {
        super(predicate);
        this.pageRetrieverProvider = Objects.requireNonNull(supplier, "'pageRetrieverProvider' function cannot be null.");
        if (n2 != null && n2 <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'pageSize' must be greater than 0 required but provided: " + n2));
        }
        this.defaultPageSize = n2;
    }

    public Integer getPageSize() {
        return this.defaultPageSize;
    }

    @Override
    public Flux<P> byPage() {
        return this.byPage(this.pageRetrieverProvider, null, this.defaultPageSize);
    }

    @Override
    public Flux<P> byPage(C c2) {
        if (c2 == null) {
            return Flux.empty();
        }
        return this.byPage(this.pageRetrieverProvider, c2, this.defaultPageSize);
    }

    @Override
    public Flux<P> byPage(int n2) {
        if (n2 <= 0) {
            return Flux.error((Throwable)new IllegalArgumentException("preferredPageSize > 0 required but provided: " + n2));
        }
        return this.byPage(this.pageRetrieverProvider, null, n2);
    }

    @Override
    public Flux<P> byPage(C c2, int n2) {
        if (n2 <= 0) {
            return Flux.error((Throwable)new IllegalArgumentException("preferredPageSize > 0 required but provided: " + n2));
        }
        if (c2 == null) {
            return Flux.empty();
        }
        return this.byPage(this.pageRetrieverProvider, c2, n2);
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        this.byPage(this.pageRetrieverProvider, null, this.defaultPageSize).flatMap(continuablePage -> {
            IterableStream iterableStream = continuablePage.getElements();
            return iterableStream == null ? Flux.empty() : Flux.fromIterable(continuablePage.getElements());
        }).subscribe(coreSubscriber);
    }

    private Flux<P> byPage(Supplier<PageRetriever<C, P>> supplier, C c2, Integer n2) {
        return Flux.defer(() -> {
            PageRetriever pageRetriever = (PageRetriever)supplier.get();
            ContinuationState<Object> continuationState = new ContinuationState<Object>(c2, this.getContinuationPredicate());
            return this.retrievePages(continuationState, pageRetriever, n2);
        });
    }

    private Flux<P> retrievePages(ContinuationState<C> continuationState, PageRetriever<C, P> pageRetriever, Integer n2) {
        return this.retrievePage(continuationState, pageRetriever, n2).expand(continuablePage -> {
            continuationState.setLastContinuationToken(continuablePage.getContinuationToken());
            return Flux.defer(() -> this.retrievePage(continuationState, pageRetriever, n2));
        }, 4);
    }

    private Flux<P> retrievePage(ContinuationState<C> continuationState, PageRetriever<C, P> pageRetriever, Integer n2) {
        if (continuationState.isDone()) {
            return Flux.empty();
        }
        return pageRetriever.get(continuationState.getLastContinuationToken(), n2).switchIfEmpty((Publisher)Mono.fromRunnable(() -> continuationState.setLastContinuationToken(null)));
    }
}

