/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePage;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedByIteratorBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuationState;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetriever;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetrieverSync;

final class ContinuablePagedByItemIterable<C, T, P extends ContinuablePage<C, T>>
implements Iterable<T> {
    private final PageRetriever<C, P> pageRetriever;
    private final PageRetrieverSync<C, P> pageRetrieverSync;
    private final C continuationToken;
    private final Predicate<C> continuationPredicate;
    private final Integer preferredPageSize;

    ContinuablePagedByItemIterable(PageRetriever<C, P> pageRetriever, C c2, Predicate<C> predicate, Integer n2) {
        this.pageRetriever = pageRetriever;
        this.continuationToken = c2;
        this.continuationPredicate = predicate;
        this.preferredPageSize = n2;
        this.pageRetrieverSync = null;
    }

    ContinuablePagedByItemIterable(PageRetrieverSync<C, P> pageRetrieverSync, C c2, Predicate<C> predicate, Integer n2) {
        this.pageRetrieverSync = pageRetrieverSync;
        this.continuationToken = c2;
        this.continuationPredicate = predicate;
        this.preferredPageSize = n2;
        this.pageRetriever = null;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.pageRetriever != null) {
            return new ContinuablePagedByItemIterator(this.pageRetriever, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
        }
        return new ContinuablePagedByItemIterator(this.pageRetrieverSync, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
    }

    private static final class ContinuablePagedByItemIterator<C, T, P extends ContinuablePage<C, T>>
    extends ContinuablePagedByIteratorBase<C, T, P, T> {
        private static final ClientLogger LOGGER = new ClientLogger(ContinuablePagedByItemIterator.class);
        private volatile Queue<Iterator<T>> pages = new ConcurrentLinkedQueue<Iterator<T>>();
        private volatile Iterator<T> currentPage;

        ContinuablePagedByItemIterator(PageRetriever<C, P> pageRetriever, C c2, Predicate<C> predicate, Integer n2) {
            super(pageRetriever, new ContinuationState<C>(c2, predicate), n2, LOGGER);
            this.requestPage();
        }

        ContinuablePagedByItemIterator(PageRetrieverSync<C, P> pageRetrieverSync, C c2, Predicate<C> predicate, Integer n2) {
            super(pageRetrieverSync, new ContinuationState<C>(c2, predicate), n2, LOGGER);
            this.requestPage();
        }

        @Override
        boolean needToRequestPage() {
            return (this.currentPage == null || !this.currentPage.hasNext()) && this.pages.peek() == null;
        }

        @Override
        public boolean isNextAvailable() {
            return this.currentPage != null && this.currentPage.hasNext() || this.pages.peek() != null;
        }

        @Override
        T getNext() {
            if (!(this.currentPage != null && this.currentPage.hasNext() || this.pages.peek() == null)) {
                this.currentPage = this.pages.poll();
            }
            return this.currentPage.next();
        }

        @Override
        void addPage(P p2) {
            Iterator iterator = p2.getElements().iterator();
            if (iterator.hasNext()) {
                this.pages.add(iterator);
            }
        }
    }
}

