/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.accesshelpers.ClientLoggerAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.logging.DefaultLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.logging.LoggingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.NOPLogger;

public class ClientLogger {
    private final Logger logger;
    private final String globalContextSerialized;
    private final boolean hasGlobalContext;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String string) {
        this(string, Collections.emptyMap());
    }

    public ClientLogger(Class<?> clazz, Map<String, Object> map) {
        this(clazz.getName(), map);
    }

    public ClientLogger(String string, Map<String, Object> map) {
        this(ClientLogger.getLogger(string), map);
    }

    private static Logger getLogger(String string) {
        Logger logger = LoggerFactory.getLogger(string);
        return logger instanceof NOPLogger ? new DefaultLogger(string) : logger;
    }

    ClientLogger(Logger logger, Map<String, Object> map) {
        this.logger = logger;
        this.globalContextSerialized = LoggingEventBuilder.writeJsonFragment(map);
        this.hasGlobalContext = !CoreUtils.isNullOrEmpty(this.globalContextSerialized);
    }

    public void log(LogLevel logLevel, Supplier<String> supplier) {
        this.log(logLevel, supplier, null);
    }

    public void log(LogLevel logLevel, Supplier<String> supplier, Throwable throwable) {
        if (supplier != null && this.canLogAtLevel(logLevel)) {
            this.performDeferredLogging(logLevel, supplier, throwable);
        }
    }

    public void verbose(String string) {
        if (this.logger.isDebugEnabled()) {
            if (this.hasGlobalContext) {
                this.atVerbose().log(string);
            } else {
                this.logger.debug(LoggingUtils.removeNewLinesFromLogMessage(string));
            }
        }
    }

    public void verbose(String string, Object ... objectArray) {
        if (this.logger.isDebugEnabled()) {
            this.performLogging(LogLevel.VERBOSE, false, string, objectArray);
        }
    }

    public void info(String string) {
        if (this.logger.isInfoEnabled()) {
            if (this.hasGlobalContext) {
                this.atInfo().log(string);
            } else {
                this.logger.info(LoggingUtils.removeNewLinesFromLogMessage(string));
            }
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.logger.isInfoEnabled()) {
            this.performLogging(LogLevel.INFORMATIONAL, false, string, objectArray);
        }
    }

    public void warning(String string) {
        if (this.logger.isWarnEnabled()) {
            if (this.hasGlobalContext) {
                this.atWarning().log(string);
            } else {
                this.logger.warn(LoggingUtils.removeNewLinesFromLogMessage(string));
            }
        }
    }

    public void warning(String string, Object ... objectArray) {
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, false, string, objectArray);
        }
    }

    public void error(String string) {
        if (this.logger.isErrorEnabled()) {
            if (this.hasGlobalContext) {
                this.atError().log(string);
            } else {
                this.logger.error(LoggingUtils.removeNewLinesFromLogMessage(string));
            }
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.logger.isErrorEnabled()) {
            this.performLogging(LogLevel.ERROR, false, string, objectArray);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsWarning(runtimeException);
    }

    @Deprecated
    public <T extends Throwable> T logThowableAsWarning(T t2) {
        Objects.requireNonNull(t2, "'throwable' cannot be null.");
        if (!this.logger.isWarnEnabled()) {
            return t2;
        }
        this.performLogging(LogLevel.WARNING, true, t2.getMessage(), t2);
        return t2;
    }

    public <T extends Throwable> T logThrowableAsWarning(T t2) {
        Objects.requireNonNull(t2, "'throwable' cannot be null.");
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, true, t2.getMessage(), t2);
        }
        return t2;
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsError(runtimeException);
    }

    public <T extends Throwable> T logThrowableAsError(T t2) {
        Objects.requireNonNull(t2, "'throwable' cannot be null.");
        if (!this.logger.isErrorEnabled()) {
            return t2;
        }
        this.performLogging(LogLevel.ERROR, true, t2.getMessage(), t2);
        return t2;
    }

    private void performLogging(LogLevel logLevel, boolean bl2, String string, Object ... objectArray) {
        if (this.hasGlobalContext) {
            LoggingEventBuilder.create(this.logger, logLevel, this.globalContextSerialized, true).log(string, objectArray);
            return;
        }
        String string2 = "";
        if (LoggingUtils.doesArgsHaveThrowable(objectArray)) {
            Object object;
            if (!bl2 && (object = objectArray[objectArray.length - 1]) instanceof Throwable) {
                string2 = ((Throwable)object).getMessage();
            }
            if (!this.logger.isDebugEnabled()) {
                objectArray = LoggingUtils.removeThrowable(objectArray);
            }
        }
        string = LoggingUtils.removeNewLinesFromLogMessage(string);
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(string, objectArray);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(string, objectArray);
                break;
            }
            case WARNING: {
                if (!CoreUtils.isNullOrEmpty(string2)) {
                    string = string + System.lineSeparator() + string2;
                }
                this.logger.warn(string, objectArray);
                break;
            }
            case ERROR: {
                if (!CoreUtils.isNullOrEmpty(string2)) {
                    string = string + System.lineSeparator() + string2;
                }
                this.logger.error(string, objectArray);
                break;
            }
        }
    }

    private void performDeferredLogging(LogLevel logLevel, Supplier<String> supplier, Throwable throwable) {
        if (this.hasGlobalContext) {
            LoggingEventBuilder.create(this.logger, logLevel, this.globalContextSerialized, true).log(supplier, throwable);
            return;
        }
        String string = LoggingUtils.removeNewLinesFromLogMessage(supplier.get());
        String string2 = throwable != null ? throwable.getMessage() : "";
        switch (logLevel) {
            case VERBOSE: {
                if (throwable != null) {
                    this.logger.debug(string, throwable);
                    break;
                }
                this.logger.debug(string);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(string);
                break;
            }
            case WARNING: {
                if (!CoreUtils.isNullOrEmpty(string2)) {
                    string = string + System.lineSeparator() + string2;
                }
                this.logger.warn(string);
                break;
            }
            case ERROR: {
                if (!CoreUtils.isNullOrEmpty(string2)) {
                    string = string + System.lineSeparator() + string2;
                }
                this.logger.error(string);
                break;
            }
        }
    }

    Object[] evaluateSupplierArgument(Object[] objectArray) {
        if (this.isSupplierLogging(objectArray)) {
            objectArray[0] = ((Supplier)objectArray[0]).get();
        }
        return objectArray;
    }

    boolean isSupplierLogging(Object[] objectArray) {
        return objectArray.length == 1 && objectArray[0] instanceof Supplier || objectArray.length == 2 && objectArray[0] instanceof Supplier && (objectArray[1] instanceof Throwable || objectArray[1] == null);
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        switch (logLevel) {
            case VERBOSE: {
                return this.logger.isDebugEnabled();
            }
            case INFORMATIONAL: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    public LoggingEventBuilder atError() {
        return LoggingEventBuilder.create(this.logger, LogLevel.ERROR, this.globalContextSerialized, this.canLogAtLevel(LogLevel.ERROR));
    }

    public LoggingEventBuilder atWarning() {
        return LoggingEventBuilder.create(this.logger, LogLevel.WARNING, this.globalContextSerialized, this.canLogAtLevel(LogLevel.WARNING));
    }

    public LoggingEventBuilder atInfo() {
        return LoggingEventBuilder.create(this.logger, LogLevel.INFORMATIONAL, this.globalContextSerialized, this.canLogAtLevel(LogLevel.INFORMATIONAL));
    }

    public LoggingEventBuilder atVerbose() {
        return LoggingEventBuilder.create(this.logger, LogLevel.VERBOSE, this.globalContextSerialized, this.canLogAtLevel(LogLevel.VERBOSE));
    }

    public LoggingEventBuilder atLevel(LogLevel logLevel) {
        return LoggingEventBuilder.create(this.logger, logLevel, this.globalContextSerialized, this.canLogAtLevel(logLevel));
    }

    static {
        ClientLoggerAccessHelper.setAccessor(ClientLogger::new);
    }
}

