/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.function.BiFunction;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.StreamResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AsynchronousFileChannelAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ByteCountingAsynchronousByteChannel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ProgressReporter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.MonoSink;

public final class IOUtils {
    private static final ClientLogger LOGGER = new ClientLogger(IOUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int SIXTY_FOUR_KB = 65536;
    private static final int THIRTY_TWO_KB = 32768;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;

    public static AsynchronousByteChannel toAsynchronousByteChannel(AsynchronousFileChannel asynchronousFileChannel, long l2) {
        Objects.requireNonNull(asynchronousFileChannel, "'fileChannel' must not be null");
        if (l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be less than 0."));
        }
        return new AsynchronousFileChannelAdapter(asynchronousFileChannel, l2);
    }

    public static void transfer(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        IOUtils.transfer(readableByteChannel, writableByteChannel, null);
    }

    public static void transfer(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, Long l2) throws IOException {
        int n2;
        if (readableByteChannel == null && writableByteChannel == null) {
            throw new NullPointerException("'source' and 'destination' cannot be null.");
        }
        if (readableByteChannel == null) {
            throw new NullPointerException("'source' cannot be null.");
        }
        if (writableByteChannel == null) {
            throw new NullPointerException("'destination' cannot be null.");
        }
        int n3 = l2 == null ? IOUtils.getBufferSize(readableByteChannel) : IOUtils.getBufferSize(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        do {
            byteBuffer.clear();
            n2 = readableByteChannel.read(byteBuffer);
            byteBuffer.flip();
            ImplUtils.fullyWriteBuffer(byteBuffer, writableByteChannel);
        } while (n2 >= 0);
    }

    public static Mono<Void> transferAsync(ReadableByteChannel readableByteChannel, AsynchronousByteChannel asynchronousByteChannel) {
        return IOUtils.transferAsync(readableByteChannel, asynchronousByteChannel, null);
    }

    public static Mono<Void> transferAsync(ReadableByteChannel readableByteChannel, AsynchronousByteChannel asynchronousByteChannel, Long l2) {
        if (readableByteChannel == null && asynchronousByteChannel == null) {
            return Mono.error((Throwable)new NullPointerException("'source' and 'destination' cannot be null."));
        }
        if (readableByteChannel == null) {
            return Mono.error((Throwable)new NullPointerException("'source' cannot be null."));
        }
        if (asynchronousByteChannel == null) {
            return Mono.error((Throwable)new NullPointerException("'destination' cannot be null."));
        }
        int n2 = l2 == null ? IOUtils.getBufferSize(readableByteChannel) : IOUtils.getBufferSize(l2);
        return Mono.create(monoSink -> monoSink.onRequest(l2 -> {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            try {
                IOUtils.transferAsynchronously(readableByteChannel, asynchronousByteChannel, byteBuffer, (MonoSink<Void>)monoSink);
            }
            catch (IOException iOException) {
                monoSink.error((Throwable)iOException);
            }
        }));
    }

    private static void transferAsynchronously(final ReadableByteChannel readableByteChannel, final AsynchronousByteChannel asynchronousByteChannel, final ByteBuffer byteBuffer, final MonoSink<Void> monoSink) throws IOException {
        byteBuffer.clear();
        int n2 = readableByteChannel.read(byteBuffer);
        if (n2 >= 0) {
            byteBuffer.flip();
            asynchronousByteChannel.write(byteBuffer, byteBuffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer n2, ByteBuffer byteBuffer2) {
                    try {
                        if (byteBuffer.hasRemaining()) {
                            asynchronousByteChannel.write(byteBuffer, byteBuffer, this);
                        } else {
                            IOUtils.transferAsynchronously(readableByteChannel, asynchronousByteChannel, byteBuffer, (MonoSink<Void>)monoSink);
                        }
                    }
                    catch (IOException iOException) {
                        monoSink.error((Throwable)iOException);
                    }
                }

                @Override
                public void failed(Throwable throwable, ByteBuffer byteBuffer2) {
                    monoSink.error(throwable);
                }
            });
        } else {
            monoSink.success();
        }
    }

    public static Mono<Void> transferStreamResponseToAsynchronousByteChannel(AsynchronousByteChannel asynchronousByteChannel, StreamResponse streamResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> biFunction, ProgressReporter progressReporter, int n2) {
        return IOUtils.transferStreamResponseToAsynchronousByteChannelHelper(new ByteCountingAsynchronousByteChannel(asynchronousByteChannel, null, progressReporter), streamResponse, biFunction, n2, 0);
    }

    private static Mono<Void> transferStreamResponseToAsynchronousByteChannelHelper(ByteCountingAsynchronousByteChannel byteCountingAsynchronousByteChannel, StreamResponse streamResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> biFunction, int n2, int n3) {
        return Mono.using(() -> streamResponse, streamResponse2 -> streamResponse2.writeValueToAsync(byteCountingAsynchronousByteChannel).onErrorResume(Exception.class, exception -> {
            streamResponse.close();
            int n4 = n3 + 1;
            if (n4 > n2) {
                IOUtils.createBasicLoggingContext(LogLevel.ERROR, streamResponse).addKeyValue("tryCount", n3).log("Retry attempts have been exhausted.", exception);
                return Mono.error((Throwable)exception);
            }
            long l2 = byteCountingAsynchronousByteChannel.getBytesWritten();
            IOUtils.createBasicLoggingContext(LogLevel.INFORMATIONAL, streamResponse).addKeyValue("tryCount", n3).addKeyValue("maxRetries", n2).addKeyValue("bytesWritten", l2).log("Attempt failed. Scheduling retry.", exception);
            return ((Mono)biFunction.apply((Throwable)exception, l2)).flatMap(streamResponse -> IOUtils.transferStreamResponseToAsynchronousByteChannelHelper(byteCountingAsynchronousByteChannel, streamResponse, biFunction, n2, n4));
        }), StreamResponse::close);
    }

    private static int getBufferSize(ReadableByteChannel readableByteChannel) {
        if (!(readableByteChannel instanceof SeekableByteChannel)) {
            return 8192;
        }
        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)readableByteChannel;
        try {
            long l2 = seekableByteChannel.size();
            long l3 = seekableByteChannel.position();
            return IOUtils.getBufferSize(l2 - l3);
        }
        catch (IOException iOException) {
            return 8192;
        }
    }

    private static int getBufferSize(long l2) {
        if (l2 > 0x40000000L) {
            return 65536;
        }
        if (l2 > 0x100000L) {
            return 32768;
        }
        return 8192;
    }

    private static LoggingEventBuilder createBasicLoggingContext(LogLevel logLevel, StreamResponse streamResponse) {
        LoggingEventBuilder loggingEventBuilder = LOGGER.atLevel(logLevel);
        if (LOGGER.canLogAtLevel(logLevel)) {
            String string;
            String string2 = streamResponse.getRequest().getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
            if (string2 != null) {
                loggingEventBuilder.addKeyValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID.getCaseInsensitiveName(), string2);
            }
            if ((string = streamResponse.getRequest().getHeaders().getValue(HttpHeaderName.TRACEPARENT)) != null) {
                loggingEventBuilder.addKeyValue(HttpHeaderName.TRACEPARENT.getCaseInsensitiveName(), string);
            }
        }
        return loggingEventBuilder;
    }

    private IOUtils() {
    }
}

