/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationProperty;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class SharedExecutorService
implements ExecutorService {
    private static final ClientLogger LOGGER;
    private static final AtomicLong AZURE_SDK_THREAD_COUNTER;
    private static final String AZURE_SDK_THREAD_NAME = "azure-sdk-global-thread-";
    private static final int THREAD_POOL_SIZE;
    private static final int THREAD_POOL_KEEP_ALIVE_MILLIS;
    private static final boolean THREAD_POOL_VIRTUAL;
    private static final SharedExecutorService INSTANCE;
    private static final boolean VIRTUAL_THREAD_SUPPORTED;
    private static final ReflectiveInvoker GET_VIRTUAL_THREAD_BUILDER;
    private static final ReflectiveInvoker SET_VIRTUAL_THREAD_BUILDER_THREAD_NAME;
    private static final ReflectiveInvoker CREATE_VIRTUAL_THREAD_FACTORY;
    private final ExecutorService executorService = SharedExecutorService.createSharedExecutor();

    private static <T> T getConfig(String string, String string2, Function<String, T> function, T t2) {
        String string3 = Configuration.getGlobalConfiguration().getFromEnvironment(string, string2, ConfigurationProperty.REDACT_VALUE_SANITIZER);
        if (string3 == null) {
            LOGGER.atVerbose().addKeyValue("systemProperty", string).addKeyValue("envVar", string2).addKeyValue("defaultValue", t2).log("Configuration value not found, using default.");
            return t2;
        }
        try {
            T t3 = function.apply(string3);
            LOGGER.atVerbose().addKeyValue("systemProperty", string).addKeyValue("envVar", string2).addKeyValue("value", string3).log("Found configuration value.");
            return t3;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.atVerbose().addKeyValue("systemProperty", string).addKeyValue("envVar", string2).addKeyValue("value", string3).addKeyValue("defaultValue", t2).log("Failed to convert found configuration value, using default.");
            return t2;
        }
    }

    private SharedExecutorService() {
    }

    public static SharedExecutorService getInstance() {
        return INSTANCE;
    }

    @Override
    public void shutdown() {
        throw LOGGER.logThrowableAsError(new UnsupportedOperationException("This executor service is shared and cannot be shut down."));
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw LOGGER.logThrowableAsError(new UnsupportedOperationException("This executor service is shared and cannot be shut down."));
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        throw LOGGER.logThrowableAsError(new UnsupportedOperationException("This executor service is shared and cannot be terminated."));
    }

    @Override
    public void execute(Runnable runnable) {
        this.ensureNotShutdown().execute(runnable);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.ensureNotShutdown().submit(callable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        return this.ensureNotShutdown().submit(runnable, t2);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.ensureNotShutdown().submit(runnable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.ensureNotShutdown().invokeAll(collection);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.ensureNotShutdown().invokeAll(collection, l2, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.ensureNotShutdown().invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.ensureNotShutdown().invokeAny(collection, l2, timeUnit);
    }

    private ExecutorService ensureNotShutdown() {
        return this.executorService;
    }

    private static ExecutorService createSharedExecutor() {
        ThreadFactory threadFactory;
        if (VIRTUAL_THREAD_SUPPORTED && THREAD_POOL_VIRTUAL) {
            try {
                LOGGER.verbose("Attempting to create a virtual thread factory.");
                threadFactory = SharedExecutorService.createVirtualThreadFactory();
                LOGGER.verbose("Successfully created a virtual thread factory.");
            }
            catch (Exception exception) {
                LOGGER.info("Failed to create a virtual thread factory, falling back to non-virtual threads.", exception);
                threadFactory = SharedExecutorService.createNonVirtualThreadFactory();
            }
        } else {
            threadFactory = SharedExecutorService.createNonVirtualThreadFactory();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, THREAD_POOL_SIZE, (long)THREAD_POOL_KEEP_ALIVE_MILLIS, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        Thread thread = CoreUtils.createExecutorServiceShutdownThread(threadPoolExecutor, Duration.ofSeconds(5L));
        CoreUtils.addShutdownHookSafely(thread);
        return threadPoolExecutor;
    }

    private static ThreadFactory createVirtualThreadFactory() throws Exception {
        Object object = GET_VIRTUAL_THREAD_BUILDER.invokeStatic(new Object[0]);
        SET_VIRTUAL_THREAD_BUILDER_THREAD_NAME.invokeWithArguments(object, AZURE_SDK_THREAD_NAME);
        return (ThreadFactory)CREATE_VIRTUAL_THREAD_FACTORY.invokeWithArguments(object, new Object[0]);
    }

    private static ThreadFactory createNonVirtualThreadFactory() {
        return runnable -> {
            Thread thread = new Thread(runnable, AZURE_SDK_THREAD_NAME + AZURE_SDK_THREAD_COUNTER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        };
    }

    static {
        boolean bl2;
        ReflectiveInvoker reflectiveInvoker;
        ReflectiveInvoker reflectiveInvoker2;
        ReflectiveInvoker reflectiveInvoker3;
        LOGGER = new ClientLogger(SharedExecutorService.class);
        AZURE_SDK_THREAD_COUNTER = new AtomicLong();
        THREAD_POOL_SIZE = SharedExecutorService.getConfig("azure.sdk.shared.threadpool.maxpoolsize", "AZURE_SDK_SHARED_THREADPOOL_MAXPOOLSIZE", Integer::parseInt, 10 * Runtime.getRuntime().availableProcessors());
        THREAD_POOL_KEEP_ALIVE_MILLIS = SharedExecutorService.getConfig("azure.sdk.shared.threadpool.keepalivemillis", "AZURE_SDK_SHARED_THREADPOOL_KEEPALIVEMILLIS", Integer::parseInt, 60000);
        THREAD_POOL_VIRTUAL = SharedExecutorService.getConfig("azure.sdk.shared.threadpool.usevirtualthreads", "AZURE_SDK_SHARED_THREADPOOL_USEVIRTUALTHREADS", Boolean::parseBoolean, true);
        INSTANCE = new SharedExecutorService();
        try {
            reflectiveInvoker3 = ReflectionUtils.getMethodInvoker(null, Class.forName("java.lang.Thread").getDeclaredMethod("ofVirtual", new Class[0]));
            reflectiveInvoker2 = ReflectionUtils.getMethodInvoker(null, Class.forName("java.lang.Thread$Builder").getDeclaredMethod("name", String.class));
            reflectiveInvoker = ReflectionUtils.getMethodInvoker(null, Class.forName("java.lang.Thread$Builder").getDeclaredMethod("factory", new Class[0]));
            bl2 = true;
            LOGGER.verbose("Virtual threads are supported in the current runtime.");
        }
        catch (Exception | LinkageError throwable) {
            LOGGER.atVerbose().addKeyValue("runtime", System.getProperty("java.version")).log("Virtual threads are not supported in the current runtime.", throwable);
            bl2 = false;
            reflectiveInvoker3 = null;
            reflectiveInvoker2 = null;
            reflectiveInvoker = null;
        }
        VIRTUAL_THREAD_SUPPORTED = bl2;
        GET_VIRTUAL_THREAD_BUILDER = reflectiveInvoker3;
        SET_VIRTUAL_THREAD_BUILDER_THREAD_NAME = reflectiveInvoker2;
        CREATE_VIRTUAL_THREAD_FACTORY = reflectiveInvoker;
    }
}

