/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonCreator;

public final class DateTimeRfc1123 {
    private static final ClientLogger LOGGER = new ClientLogger(DateTimeRfc1123.class);
    private final OffsetDateTime dateTime;

    public DateTimeRfc1123(OffsetDateTime offsetDateTime) {
        this.dateTime = offsetDateTime;
    }

    public DateTimeRfc1123(String string) {
        this.dateTime = DateTimeRfc1123.parse(string);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    @JsonCreator
    static DateTimeRfc1123 fromString(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            return null;
        }
        return new DateTimeRfc1123(string);
    }

    private static OffsetDateTime parse(String string) {
        try {
            return OffsetDateTime.of(LocalDateTime.of(DateTimeRfc1123.parseInt(string, 12, 16), DateTimeRfc1123.parseMonth(string), DateTimeRfc1123.parseInt(string, 5, 7), DateTimeRfc1123.parseInt(string, 17, 19), DateTimeRfc1123.parseInt(string, 20, 22), DateTimeRfc1123.parseInt(string, 23, 25), 0), ZoneOffset.UTC);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | DateTimeException runtimeException) {
            return OffsetDateTime.parse(string, DateTimeFormatter.RFC_1123_DATE_TIME);
        }
    }

    private static int parseInt(String string, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0' || c2 > '9') {
                throw LOGGER.logExceptionAsError(new DateTimeException("Invalid date time: " + string));
            }
            n4 = n4 * 10 + (c2 - 48);
        }
        return n4;
    }

    private static Month parseMonth(CharSequence charSequence) {
        switch (charSequence.charAt(8)) {
            case 'J': {
                switch (charSequence.charAt(9)) {
                    case 'a': {
                        return Month.JANUARY;
                    }
                    case 'u': {
                        switch (charSequence.charAt(10)) {
                            case 'n': {
                                return Month.JUNE;
                            }
                            case 'l': {
                                return Month.JULY;
                            }
                        }
                        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + charSequence));
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + charSequence));
            }
            case 'F': {
                return Month.FEBRUARY;
            }
            case 'M': {
                switch (charSequence.charAt(10)) {
                    case 'r': {
                        return Month.MARCH;
                    }
                    case 'y': {
                        return Month.MAY;
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + charSequence));
            }
            case 'A': {
                switch (charSequence.charAt(10)) {
                    case 'r': {
                        return Month.APRIL;
                    }
                    case 'g': {
                        return Month.AUGUST;
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + charSequence));
            }
            case 'S': {
                return Month.SEPTEMBER;
            }
            case 'O': {
                return Month.OCTOBER;
            }
            case 'N': {
                return Month.NOVEMBER;
            }
            case 'D': {
                return Month.DECEMBER;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + charSequence));
    }

    public static String toRfc1123String(OffsetDateTime offsetDateTime) {
        offsetDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC);
        byte[] byArray = new byte[29];
        DayOfWeek dayOfWeek = offsetDateTime.getDayOfWeek();
        switch (dayOfWeek) {
            case MONDAY: {
                byArray[0] = 77;
                byArray[1] = 111;
                byArray[2] = 110;
                break;
            }
            case TUESDAY: {
                byArray[0] = 84;
                byArray[1] = 117;
                byArray[2] = 101;
                break;
            }
            case WEDNESDAY: {
                byArray[0] = 87;
                byArray[1] = 101;
                byArray[2] = 100;
                break;
            }
            case THURSDAY: {
                byArray[0] = 84;
                byArray[1] = 104;
                byArray[2] = 117;
                break;
            }
            case FRIDAY: {
                byArray[0] = 70;
                byArray[1] = 114;
                byArray[2] = 105;
                break;
            }
            case SATURDAY: {
                byArray[0] = 83;
                byArray[1] = 97;
                byArray[2] = 116;
                break;
            }
            case SUNDAY: {
                byArray[0] = 83;
                byArray[1] = 117;
                byArray[2] = 110;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown day of week " + dayOfWeek));
            }
        }
        byArray[3] = 44;
        byArray[4] = 32;
        DateTimeRfc1123.zeroPad(offsetDateTime.getDayOfMonth(), byArray, 5);
        byArray[7] = 32;
        Month month = offsetDateTime.getMonth();
        switch (month) {
            case JANUARY: {
                byArray[8] = 74;
                byArray[9] = 97;
                byArray[10] = 110;
                break;
            }
            case FEBRUARY: {
                byArray[8] = 70;
                byArray[9] = 101;
                byArray[10] = 98;
                break;
            }
            case MARCH: {
                byArray[8] = 77;
                byArray[9] = 97;
                byArray[10] = 114;
                break;
            }
            case APRIL: {
                byArray[8] = 65;
                byArray[9] = 112;
                byArray[10] = 114;
                break;
            }
            case MAY: {
                byArray[8] = 77;
                byArray[9] = 97;
                byArray[10] = 121;
                break;
            }
            case JUNE: {
                byArray[8] = 74;
                byArray[9] = 117;
                byArray[10] = 110;
                break;
            }
            case JULY: {
                byArray[8] = 74;
                byArray[9] = 117;
                byArray[10] = 108;
                break;
            }
            case AUGUST: {
                byArray[8] = 65;
                byArray[9] = 117;
                byArray[10] = 103;
                break;
            }
            case SEPTEMBER: {
                byArray[8] = 83;
                byArray[9] = 101;
                byArray[10] = 112;
                break;
            }
            case OCTOBER: {
                byArray[8] = 79;
                byArray[9] = 99;
                byArray[10] = 116;
                break;
            }
            case NOVEMBER: {
                byArray[8] = 78;
                byArray[9] = 111;
                byArray[10] = 118;
                break;
            }
            case DECEMBER: {
                byArray[8] = 68;
                byArray[9] = 101;
                byArray[10] = 99;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + month));
            }
        }
        byArray[11] = 32;
        int n2 = offsetDateTime.getYear();
        int n3 = n2 / 1000;
        byArray[12] = (byte)(48 + n3);
        n2 -= 1000 * n3;
        n3 = n2 / 100;
        byArray[13] = (byte)(48 + n3);
        n2 -= 100 * n3;
        n3 = n2 / 10;
        byArray[14] = (byte)(48 + n3);
        byArray[15] = (byte)(48 + (n2 - 10 * n3));
        byArray[16] = 32;
        DateTimeRfc1123.zeroPad(offsetDateTime.getHour(), byArray, 17);
        byArray[19] = 58;
        DateTimeRfc1123.zeroPad(offsetDateTime.getMinute(), byArray, 20);
        byArray[22] = 58;
        DateTimeRfc1123.zeroPad(offsetDateTime.getSecond(), byArray, 23);
        byArray[25] = 32;
        byArray[26] = 71;
        byArray[27] = 77;
        byArray[28] = 84;
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private static void zeroPad(int n2, byte[] byArray, int n3) {
        if (n2 < 10) {
            byArray[n3++] = 48;
            byArray[n3] = (byte)(48 + n2);
        } else {
            int n4 = n2 / 10;
            byArray[n3++] = (byte)(48 + n4);
            byArray[n3] = (byte)(48 + (n2 - 10 * n4));
        }
    }

    public String toString() {
        return DateTimeRfc1123.toRfc1123String(this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 dateTimeRfc1123 = (DateTimeRfc1123)object;
        return this.dateTime.equals(dateTimeRfc1123.getDateTime());
    }
}

