/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.PagedResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;

public final class CoreUtils {
    private static final ClientLogger LOGGER = new ClientLogger(CoreUtils.class);
    private static final char[] LOWERCASE_HEX_CHARACTERS = "0123456789abcdef".toCharArray();

    private CoreUtils() {
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static int[] clone(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static <T> T[] clone(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        return Arrays.copyOf(TArray, TArray.length);
    }

    public static boolean isNullOrEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static <T> String arrayToString(T[] TArray, Function<T, String> function) {
        if (CoreUtils.isNullOrEmpty(TArray)) {
            return null;
        }
        return Arrays.stream(TArray).map(function).collect(Collectors.joining(","));
    }

    public static <T> T findFirstOfType(Object[] objectArray, Class<T> clazz) {
        if (CoreUtils.isNullOrEmpty(objectArray)) {
            return null;
        }
        for (Object object : objectArray) {
            if (!clazz.isInstance(object)) continue;
            return clazz.cast(object);
        }
        return null;
    }

    @Deprecated
    public static <T> Publisher<T> extractAndFetch(PagedResponse<T> pagedResponse, Context context, BiFunction<String, Context, Publisher<T>> biFunction) {
        String string = (String)pagedResponse.getContinuationToken();
        if (string == null) {
            return Flux.fromIterable(pagedResponse.getElements());
        }
        return Flux.fromIterable(pagedResponse.getElements()).concatWith(biFunction.apply(string, context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getProperties(String string) {
        try (InputStream inputStream = CoreUtils.class.getClassLoader().getResourceAsStream(string);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException iOException) {
            LOGGER.log(LogLevel.WARNING, () -> "Failed to get properties from " + string, iOException);
        }
        return Collections.emptyMap();
    }

    public static String bomAwareToString(byte[] byArray, String string) {
        if (byArray == null) {
            return null;
        }
        return ImplUtils.bomAwareToString(byArray, 0, byArray.length, string);
    }

    public static String getApplicationId(ClientOptions clientOptions, HttpLogOptions httpLogOptions) {
        if (clientOptions != null && !CoreUtils.isNullOrEmpty(clientOptions.getApplicationId())) {
            return clientOptions.getApplicationId();
        }
        if (httpLogOptions != null && !CoreUtils.isNullOrEmpty(httpLogOptions.getApplicationId())) {
            return httpLogOptions.getApplicationId();
        }
        return null;
    }

    public static HttpHeaders createHttpHeadersFromClientOptions(ClientOptions clientOptions) {
        if (clientOptions == null) {
            return null;
        }
        Iterator<Header> iterator = clientOptions.getHeaders().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        do {
            Header header = iterator.next();
            httpHeaders.set(header.getName(), header.getValue());
        } while (iterator.hasNext());
        return httpHeaders;
    }

    public static Duration getDefaultTimeoutFromEnvironment(Configuration configuration, String string, Duration duration, ClientLogger clientLogger) {
        String string2 = configuration.get(string);
        if (CoreUtils.isNullOrEmpty(string2)) {
            return duration;
        }
        try {
            long l2 = Long.parseLong(string2);
            if (l2 < 0L) {
                clientLogger.atVerbose().addKeyValue(string, l2).log("Negative timeout values are not allowed. Using 'Duration.ZERO' to indicate no timeout.");
                return Duration.ZERO;
            }
            return Duration.ofMillis(l2);
        }
        catch (NumberFormatException numberFormatException) {
            clientLogger.atInfo().addKeyValue(string, string2).addKeyValue("defaultTimeout", duration).log("Timeout is not valid number. Using default value.", numberFormatException);
            return duration;
        }
    }

    public static Context mergeContexts(Context context, Context context2) {
        Objects.requireNonNull(context, "'into' cannot be null.");
        Objects.requireNonNull(context2, "'from' cannot be null.");
        if (context == Context.NONE) {
            return context2;
        }
        if (context2 == Context.NONE) {
            return context;
        }
        Context[] contextArray = context2.getContextChain();
        Context context3 = context;
        for (Context context4 : contextArray) {
            if (context4 == null) continue;
            context3 = context3.addData(context4.getKey(), context4.getValue());
        }
        return context3;
    }

    public static String stringJoin(String string, List<String> list) {
        Objects.requireNonNull(string, "'delimiter' cannot be null.");
        Objects.requireNonNull(list, "'values' cannot be null.");
        int n2 = list.size();
        switch (n2) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
            case 2: {
                return list.get(0) + string + list.get(1);
            }
            case 3: {
                return list.get(0) + string + list.get(1) + string + list.get(2);
            }
            case 4: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3);
            }
            case 5: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3) + string + list.get(4);
            }
            case 6: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3) + string + list.get(4) + string + list.get(5);
            }
            case 7: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3) + string + list.get(4) + string + list.get(5) + string + list.get(6);
            }
            case 8: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3) + string + list.get(4) + string + list.get(5) + string + list.get(6) + string + list.get(7);
            }
            case 9: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3) + string + list.get(4) + string + list.get(5) + string + list.get(6) + string + list.get(7) + string + list.get(8);
            }
            case 10: {
                return list.get(0) + string + list.get(1) + string + list.get(2) + string + list.get(3) + string + list.get(4) + string + list.get(5) + string + list.get(6) + string + list.get(7) + string + list.get(8) + string + list.get(9);
            }
        }
        return String.join((CharSequence)string, list);
    }

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = LOWERCASE_HEX_CHARACTERS[n2 >>> 4];
            cArray[i2 * 2 + 1] = LOWERCASE_HEX_CHARACTERS[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static long extractSizeFromContentRange(String string) {
        Objects.requireNonNull(string, "Cannot extract length from null 'contentRange'.");
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Content-Range header wasn't properly formatted and didn't contain a '/size' segment. The 'contentRange' was: " + string));
        }
        String string2 = string.substring(n2 + 1).trim();
        if ("*".equals(string2)) {
            return -1L;
        }
        return Long.parseLong(string2);
    }

    public static Iterator<Map.Entry<String, String>> parseQueryParameters(String string) {
        return CoreUtils.isNullOrEmpty(string) ? Collections.emptyIterator() : new ImplUtils.QueryParameterIterator(string);
    }

    public static UUID randomUuid() {
        return CoreUtils.randomUuid(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
    }

    static UUID randomUuid(long l2, long l3) {
        l2 &= 0xFFFFFFFFFFFF0FFFL;
        l3 &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(l2 |= 0x4000L, l3 |= Long.MIN_VALUE);
    }

    public static <T> T getResultWithTimeout(Future<T> future, Duration duration) throws InterruptedException, ExecutionException, TimeoutException {
        Objects.requireNonNull(future, "'future' cannot be null.");
        if (duration == null) {
            return future.get();
        }
        return ImplUtils.getResultWithTimeout(future, duration.toMillis());
    }

    public static ExecutorService addShutdownHookSafely(ExecutorService executorService, Duration duration) {
        if (executorService == null) {
            return null;
        }
        Objects.requireNonNull(duration, "'shutdownTimeout' cannot be null.");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("'shutdownTimeout' must be a non-zero positive duration.");
        }
        CoreUtils.addShutdownHookSafely(CoreUtils.createExecutorServiceShutdownThread(executorService, duration));
        return executorService;
    }

    static Thread createExecutorServiceShutdownThread(ExecutorService executorService, Duration duration) {
        long l2 = duration.toNanos();
        return new Thread(() -> {
            try {
                executorService.shutdown();
                if (!executorService.awaitTermination(l2 / 2L, TimeUnit.NANOSECONDS)) {
                    executorService.shutdownNow();
                    executorService.awaitTermination(l2 / 2L, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                executorService.shutdown();
            }
        });
    }

    public static Thread addShutdownHookSafely(Thread thread) {
        return ImplUtils.addShutdownHookSafely(thread);
    }

    public static String durationToStringWithDays(Duration duration) {
        long l2;
        long l3;
        long l4;
        long l5;
        if (duration == null) {
            return null;
        }
        if (duration.isZero()) {
            return "PT0S";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (duration.isNegative()) {
            stringBuilder.append("-P");
            duration = duration.negated();
        } else {
            stringBuilder.append('P');
        }
        long l6 = duration.toDays();
        if (l6 > 0L) {
            stringBuilder.append(l6);
            stringBuilder.append('D');
            duration = duration.minusDays(l6);
        }
        if ((l5 = duration.toHours()) > 0L) {
            stringBuilder.append('T');
            stringBuilder.append(l5);
            stringBuilder.append('H');
            duration = duration.minusHours(l5);
        }
        if ((l4 = duration.toMinutes()) > 0L) {
            if (l5 == 0L) {
                stringBuilder.append('T');
            }
            stringBuilder.append(l4);
            stringBuilder.append('M');
            duration = duration.minusMinutes(l4);
        }
        if ((l3 = duration.getSeconds()) > 0L) {
            if (l5 == 0L && l4 == 0L) {
                stringBuilder.append('T');
            }
            stringBuilder.append(l3);
            duration = duration.minusSeconds(l3);
        }
        if ((l2 = duration.toMillis()) > 0L) {
            if (l5 == 0L && l4 == 0L && l3 == 0L) {
                stringBuilder.append("T");
            }
            if (l3 == 0L) {
                stringBuilder.append("0");
            }
            stringBuilder.append('.');
            if (l2 <= 99L) {
                stringBuilder.append('0');
                if (l2 <= 9L) {
                    stringBuilder.append('0');
                }
            }
            while (l2 % 10L == 0L) {
                l2 /= 10L;
            }
            stringBuilder.append(l2);
        }
        if (l3 > 0L || l2 > 0L) {
            stringBuilder.append('S');
        }
        return stringBuilder.toString();
    }

    public static OffsetDateTime parseBestOffsetDateTime(String string) {
        if (string == null) {
            return null;
        }
        TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_DATE_TIME.parseBest(string, OffsetDateTime::from, LocalDateTime::from);
        if (temporalAccessor.query(TemporalQueries.offset()) == null) {
            return LocalDateTime.from(temporalAccessor).atOffset(ZoneOffset.UTC);
        }
        return OffsetDateTime.from(temporalAccessor);
    }
}

