/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class Context {
    private static final ClientLogger LOGGER = new ClientLogger(Context.class);
    private static final Context[] EMPTY_CHAIN = new Context[0];
    public static final Context NONE = new Context(null, null, null, 0){

        @Override
        public Optional<Object> getData(Object object) {
            if (object == null) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("key cannot be null"));
            }
            return Optional.empty();
        }

        @Override
        public Map<Object, Object> getValues() {
            return Collections.emptyMap();
        }

        @Override
        Context[] getContextChain() {
            return EMPTY_CHAIN;
        }
    };
    private final Context parent;
    private final Object key;
    private final Object value;
    private final int contextCount;
    private Map<Object, Object> valuesMap;

    public Context(Object object, Object object2) {
        this.parent = null;
        this.key = Objects.requireNonNull(object, "'key' cannot be null.");
        this.value = object2;
        this.contextCount = 1;
    }

    private Context(Context context, Object object, Object object2, int n2) {
        this.parent = context;
        this.key = object;
        this.value = object2;
        this.contextCount = n2;
    }

    Object getKey() {
        return this.key;
    }

    Object getValue() {
        return this.value;
    }

    public Context addData(Object object, Object object2) {
        if (object == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("key cannot be null"));
        }
        return new Context(this, object, object2, this.contextCount + 1);
    }

    public static Context of(Map<Object, Object> map) {
        if (CoreUtils.isNullOrEmpty(map)) {
            throw new IllegalArgumentException("Key value map cannot be null or empty");
        }
        Context context = null;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (context == null) {
                context = new Context(entry.getKey(), entry.getValue());
                continue;
            }
            context = context.addData(entry.getKey(), entry.getValue());
        }
        return context;
    }

    public Optional<Object> getData(Object object) {
        if (object == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("key cannot be null"));
        }
        Context context = this;
        while (context != null) {
            if (object.equals(context.key)) {
                return Optional.ofNullable(context.value);
            }
            if (context.contextCount == 1) {
                return Optional.empty();
            }
            context = context.parent;
        }
        return Optional.empty();
    }

    public Map<Object, Object> getValues() {
        if (this.valuesMap != null) {
            return this.valuesMap;
        }
        if (this.contextCount == 1) {
            this.valuesMap = Collections.singletonMap(this.key, this.value);
            return this.valuesMap;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>((int)Math.ceil((float)this.contextCount / 0.75f));
        Context context = this;
        while (context != null) {
            if (context.key != null) {
                hashMap.putIfAbsent(context.key, context.value);
            }
            if (context.contextCount == 1) break;
            context = context.parent;
        }
        this.valuesMap = Collections.unmodifiableMap(hashMap);
        return this.valuesMap;
    }

    Context[] getContextChain() {
        Context[] contextArray = new Context[this.contextCount];
        int n2 = this.contextCount - 1;
        Context context = this;
        while (context != null) {
            contextArray[n2--] = context;
            if (context.contextCount == 1) break;
            context = context.parent;
        }
        return contextArray;
    }
}

