/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationProperty;

public final class ConfigurationPropertyBuilder<T> {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Function<String, String> PERMIT_VALUE_SANITIZER = string -> string;
    private static final Function<String, Boolean> CONFIGURATION_PROPERTY_BOOLEAN_CONVERTER = Boolean::valueOf;
    private static final Function<String, Duration> CONFIGURATION_PROPERTY_DURATION_CONVERTER = string -> {
        long l2 = Long.parseLong(string);
        if (l2 < 0L) {
            throw new IllegalArgumentException("Duration can't be negative");
        }
        return Duration.ofMillis(l2);
    };
    private static final Function<String, Integer> CONFIGURATION_PROPERTY_INTEGER_CONVERTER = Integer::valueOf;
    private static final Function<String, String> CONFIGURATION_PROPERTY_STRING_CONVERTER = Function.identity();
    private final String name;
    private final Function<String, T> converter;
    private String[] aliases = EMPTY_ARRAY;
    private String environmentVariableName;
    private String systemPropertyName;
    private T defaultValue;
    private boolean shared;
    private Function<String, String> valueSanitizer;
    private boolean required;

    public static ConfigurationPropertyBuilder<String> ofString(String string) {
        return new ConfigurationPropertyBuilder<String>(string, CONFIGURATION_PROPERTY_STRING_CONVERTER);
    }

    public static ConfigurationPropertyBuilder<Integer> ofInteger(String string) {
        return new ConfigurationPropertyBuilder<Integer>(string, CONFIGURATION_PROPERTY_INTEGER_CONVERTER).logValue(true);
    }

    public static ConfigurationPropertyBuilder<Duration> ofDuration(String string) {
        return new ConfigurationPropertyBuilder<Duration>(string, CONFIGURATION_PROPERTY_DURATION_CONVERTER).logValue(true);
    }

    public static ConfigurationPropertyBuilder<Boolean> ofBoolean(String string) {
        return new ConfigurationPropertyBuilder<Boolean>(string, CONFIGURATION_PROPERTY_BOOLEAN_CONVERTER).logValue(true);
    }

    public ConfigurationPropertyBuilder(String string, Function<String, T> function) {
        this.name = Objects.requireNonNull(string, "'name' cannot be null");
        this.converter = Objects.requireNonNull(function, "'converter' cannot be null");
    }

    public ConfigurationPropertyBuilder<T> defaultValue(T t2) {
        this.defaultValue = t2;
        return this;
    }

    public ConfigurationPropertyBuilder<T> shared(boolean bl2) {
        this.shared = bl2;
        return this;
    }

    public ConfigurationPropertyBuilder<T> logValue(boolean bl2) {
        if (bl2) {
            this.valueSanitizer = PERMIT_VALUE_SANITIZER;
        }
        return this;
    }

    public ConfigurationPropertyBuilder<T> required(boolean bl2) {
        this.required = bl2;
        return this;
    }

    public ConfigurationPropertyBuilder<T> aliases(String ... stringArray) {
        this.aliases = stringArray;
        return this;
    }

    public ConfigurationPropertyBuilder<T> environmentVariableName(String string) {
        this.environmentVariableName = string;
        return this;
    }

    public ConfigurationPropertyBuilder<T> systemPropertyName(String string) {
        this.systemPropertyName = string;
        return this;
    }

    public ConfigurationProperty<T> build() {
        return new ConfigurationProperty<T>(this.name, this.defaultValue, this.required, this.converter, this.shared, this.environmentVariableName, this.systemPropertyName, this.aliases, this.valueSanitizer);
    }
}

