/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ConfigurationProperty<T> {
    static final Function<String, String> REDACT_VALUE_SANITIZER = string -> "redacted";
    private final String name;
    private final List<String> aliases;
    private final String environmentVariable;
    private final String systemProperty;
    private final Function<String, T> converter;
    private final Function<String, String> valueSanitizer;
    private final T defaultValue;
    private final boolean isShared;
    private final boolean isRequired;

    ConfigurationProperty(String string, T t2, boolean bl2, Function<String, T> function, boolean bl3, String string2, String string3, String[] stringArray, Function<String, String> function2) {
        this.name = Objects.requireNonNull(string, "'name' cannot be null");
        this.converter = Objects.requireNonNull(function, "'converter' cannot be null");
        this.environmentVariable = string2;
        this.systemProperty = string3;
        this.aliases = stringArray == null ? Collections.emptyList() : Arrays.asList(stringArray);
        this.defaultValue = t2;
        this.isRequired = bl2;
        this.isShared = bl3;
        this.valueSanitizer = function2 == null ? REDACT_VALUE_SANITIZER : function2;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public Function<String, String> getValueSanitizer() {
        return this.valueSanitizer;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getName() {
        return this.name;
    }

    public Function<String, T> getConverter() {
        return this.converter;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<String> getAliases() {
        return this.aliases;
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariable;
    }

    public String getSystemPropertyName() {
        return this.systemProperty;
    }
}

