/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.EnvironmentConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationProperty;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationSource;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.NoopConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class Configuration
implements Cloneable {
    public static final String PROPERTY_HTTP_PROXY = "HTTP_PROXY";
    public static final String PROPERTY_HTTPS_PROXY = "HTTPS_PROXY";
    public static final String PROPERTY_IDENTITY_ENDPOINT = "IDENTITY_ENDPOINT";
    public static final String PROPERTY_IDENTITY_HEADER = "IDENTITY_HEADER";
    public static final String PROPERTY_NO_PROXY = "NO_PROXY";
    public static final String PROPERTY_MSI_ENDPOINT = "MSI_ENDPOINT";
    public static final String PROPERTY_MSI_SECRET = "MSI_SECRET";
    public static final String PROPERTY_AZURE_SUBSCRIPTION_ID = "AZURE_SUBSCRIPTION_ID";
    public static final String PROPERTY_AZURE_USERNAME = "AZURE_USERNAME";
    public static final String PROPERTY_AZURE_PASSWORD = "AZURE_PASSWORD";
    public static final String PROPERTY_AZURE_CLIENT_ID = "AZURE_CLIENT_ID";
    public static final String PROPERTY_AZURE_CLIENT_SECRET = "AZURE_CLIENT_SECRET";
    public static final String PROPERTY_AZURE_TENANT_ID = "AZURE_TENANT_ID";
    public static final String PROPERTY_AZURE_CLIENT_CERTIFICATE_PATH = "AZURE_CLIENT_CERTIFICATE_PATH";
    public static final String PROPERTY_AZURE_CLIENT_CERTIFICATE_PASSWORD = "AZURE_CLIENT_CERTIFICATE_PASSWORD";
    public static final String PROPERTY_AZURE_IDENTITY_DISABLE_CP1 = "AZURE_IDENTITY_DISABLE_CP1";
    public static final String PROPERTY_AZURE_POD_IDENTITY_TOKEN_URL = "AZURE_POD_IDENTITY_TOKEN_URL";
    public static final String PROPERTY_AZURE_REGIONAL_AUTHORITY_NAME = "AZURE_REGIONAL_AUTHORITY_NAME";
    public static final String PROPERTY_AZURE_RESOURCE_GROUP = "AZURE_RESOURCE_GROUP";
    public static final String PROPERTY_AZURE_CLOUD = "AZURE_CLOUD";
    public static final String PROPERTY_AZURE_AUTHORITY_HOST = "AZURE_AUTHORITY_HOST";
    public static final String PROPERTY_AZURE_TELEMETRY_DISABLED = "AZURE_TELEMETRY_DISABLED";
    public static final String PROPERTY_AZURE_LOG_LEVEL = "AZURE_LOG_LEVEL";
    public static final String PROPERTY_AZURE_HTTP_LOG_DETAIL_LEVEL = "AZURE_HTTP_LOG_DETAIL_LEVEL";
    public static final String PROPERTY_AZURE_TRACING_DISABLED = "AZURE_TRACING_DISABLED";
    public static final String PROPERTY_AZURE_TRACING_IMPLEMENTATION = "AZURE_TRACING_IMPLEMENTATION";
    public static final String PROPERTY_AZURE_METRICS_DISABLED = "AZURE_METRICS_DISABLED";
    public static final String PROPERTY_AZURE_METRICS_IMPLEMENTATION = "AZURE_METRICS_IMPLEMENTATION";
    public static final String PROPERTY_AZURE_REQUEST_RETRY_COUNT = "AZURE_REQUEST_RETRY_COUNT";
    public static final String PROPERTY_AZURE_REQUEST_CONNECT_TIMEOUT = "AZURE_REQUEST_CONNECT_TIMEOUT";
    public static final String PROPERTY_AZURE_REQUEST_WRITE_TIMEOUT = "AZURE_REQUEST_WRITE_TIMEOUT";
    public static final String PROPERTY_AZURE_REQUEST_RESPONSE_TIMEOUT = "AZURE_REQUEST_RESPONSE_TIMEOUT";
    public static final String PROPERTY_AZURE_REQUEST_READ_TIMEOUT = "AZURE_REQUEST_READ_TIMEOUT";
    public static final String PROPERTY_AZURE_HTTP_CLIENT_IMPLEMENTATION = "AZURE_HTTP_CLIENT_IMPLEMENTATION";
    private static final Configuration GLOBAL_CONFIGURATION = new Configuration();
    public static final Configuration NONE = new NoopConfiguration();
    private static final ClientLogger LOGGER = new ClientLogger(Configuration.class);
    private final EnvironmentConfiguration environmentConfiguration;
    private final Map<String, String> configurations;
    private final String path;
    private final Configuration sharedConfiguration;
    private final boolean isEmpty;

    @Deprecated
    public Configuration() {
        this(Collections.emptyMap(), EnvironmentConfiguration.getGlobalConfiguration(), null, null);
    }

    Configuration(ConfigurationSource configurationSource, EnvironmentConfiguration environmentConfiguration, String string, Configuration configuration) {
        this(Configuration.readConfigurations(configurationSource, string), environmentConfiguration, string, configuration);
    }

    private Configuration(Map<String, String> map, EnvironmentConfiguration environmentConfiguration, String string, Configuration configuration) {
        this.configurations = map;
        this.isEmpty = map.isEmpty();
        this.environmentConfiguration = Objects.requireNonNull(environmentConfiguration, "'environmentConfiguration' cannot be null");
        this.path = string;
        this.sharedConfiguration = configuration;
    }

    public static Configuration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public String get(String string) {
        return this.environmentConfiguration.get(string);
    }

    public <T> T get(String string, T t2) {
        return Configuration.convertToPrimitiveOrDefault(this.get(string), t2);
    }

    public <T> T get(String string, Function<String, T> function) {
        Objects.requireNonNull(function, "'converter' can't be null");
        return function.apply(this.get(string));
    }

    @Deprecated
    public Configuration put(String string, String string2) {
        this.environmentConfiguration.put(string, string2);
        return this;
    }

    @Deprecated
    public String remove(String string) {
        return this.environmentConfiguration.remove(string);
    }

    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Deprecated
    public Configuration clone() {
        return new Configuration(this.configurations, new EnvironmentConfiguration(this.environmentConfiguration), this.path, this.sharedConfiguration);
    }

    public boolean contains(ConfigurationProperty<?> configurationProperty) {
        Objects.requireNonNull(configurationProperty, "'property' can't be null");
        return this.getWithFallback(configurationProperty) != null;
    }

    public <T> T get(ConfigurationProperty<T> configurationProperty) {
        Objects.requireNonNull(configurationProperty, "'property' cannot be null");
        String string = this.getWithFallback(configurationProperty);
        if (string == null) {
            if (configurationProperty.isRequired()) {
                throw LOGGER.atError().addKeyValue("name", configurationProperty.getName()).addKeyValue("path", this.path).log(new IllegalArgumentException("Missing required property."));
            }
            return configurationProperty.getDefaultValue();
        }
        try {
            return configurationProperty.getConverter().apply(string);
        }
        catch (RuntimeException runtimeException) {
            throw LOGGER.atError().addKeyValue("name", configurationProperty.getName()).addKeyValue("path", this.path).addKeyValue("value", configurationProperty.getValueSanitizer().apply(string)).log(runtimeException);
        }
    }

    private String getLocalProperty(String string, Iterable<String> iterable, Function<String, String> function) {
        if (this.isEmpty) {
            return null;
        }
        String string2 = this.configurations.get(string);
        if (string2 != null) {
            LOGGER.atVerbose().addKeyValue("name", string).addKeyValue("path", this.path).addKeyValue("value", () -> (String)function.apply(string2)).log("Got property value by name.");
            return string2;
        }
        for (String string3 : iterable) {
            String string4 = this.configurations.get(string3);
            if (string4 == null) continue;
            LOGGER.atVerbose().addKeyValue("name", string).addKeyValue("path", this.path).addKeyValue("alias", string3).addKeyValue("value", () -> (String)function.apply(string4)).log("Got property value by alias.");
            return string4;
        }
        return null;
    }

    private String getWithFallback(ConfigurationProperty<?> configurationProperty) {
        String string = configurationProperty.getName();
        if (!CoreUtils.isNullOrEmpty(string)) {
            String string2 = this.getLocalProperty(string, configurationProperty.getAliases(), configurationProperty.getValueSanitizer());
            if (string2 != null) {
                return string2;
            }
            if (configurationProperty.isShared() && this.sharedConfiguration != null && (string2 = this.sharedConfiguration.getLocalProperty(string, configurationProperty.getAliases(), configurationProperty.getValueSanitizer())) != null) {
                return string2;
            }
        }
        return this.getFromEnvironment(configurationProperty.getSystemPropertyName(), configurationProperty.getEnvironmentVariableName(), configurationProperty.getValueSanitizer());
    }

    String getFromEnvironment(String string, String string2, Function<String, String> function) {
        String string3;
        if (string != null && (string3 = this.environmentConfiguration.getSystemProperty(string)) != null) {
            LOGGER.atVerbose().addKeyValue("systemProperty", string).addKeyValue("value", () -> (String)function.apply(string3)).log("Got property from system property.");
            return string3;
        }
        if (string2 != null && (string3 = this.environmentConfiguration.getEnvironmentVariable(string2)) != null) {
            LOGGER.atVerbose().addKeyValue("envVar", string2).addKeyValue("value", () -> (String)function.apply(string3)).log("Got property from environment variable.");
            return string3;
        }
        return null;
    }

    private static Map<String, String> readConfigurations(ConfigurationSource configurationSource, String string) {
        Objects.requireNonNull(configurationSource, "'source' cannot be null");
        Map<String, String> map = configurationSource.getProperties(string);
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = CoreUtils.isNullOrEmpty(string) ? entry.getKey() : entry.getKey().substring(string.length() + 1);
            String string3 = entry.getValue();
            LOGGER.atVerbose().addKeyValue("name", entry.getKey()).log("Got property from configuration source.");
            if (string2 != null && string3 != null) {
                hashMap.put(string2, string3);
                continue;
            }
            LOGGER.atWarning().addKeyValue("name", entry.getKey()).log("Key or value is null, property is ignored.");
        }
        return hashMap;
    }

    private static <T> T convertToPrimitiveOrDefault(String string, T t2) {
        if (CoreUtils.isNullOrEmpty(string)) {
            return t2;
        }
        Object object = t2 instanceof Byte ? Byte.valueOf(Byte.parseByte(string)) : (t2 instanceof Short ? Short.valueOf(Short.parseShort(string)) : (t2 instanceof Integer ? Integer.valueOf(Integer.parseInt(string)) : (t2 instanceof Long ? Long.valueOf(Long.parseLong(string)) : (t2 instanceof Float ? Float.valueOf(Float.parseFloat(string)) : (t2 instanceof Double ? Double.valueOf(Double.parseDouble(string)) : (t2 instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(string)) : string))))));
        return (T)object;
    }
}

